#!/bin/bash

# Script to install pip dependencies from experiment.yml
# Skips packages that fail to install and continues with the rest

echo "Installing pip dependencies from experiment.yml..."
echo "=========================================="

# List of pip packages from experiment.yml
packages=(
    "absl-py==2.2.1"
    "aiohappyeyeballs==2.6.1"
    "aiohttp==3.11.16"
    "aiosignal==1.3.2"
    "annotated-types==0.7.0"
    "anthropic==0.49.0"
    "anyio==4.9.0"
    "anytree==2.12.1"
    "async-timeout==5.0.1"
    "asyncpg==0.30.0"
    "attrs==25.3.0"
    "autograd==1.7.0"
    "banks==2.1.1"
    "beartype==0.18.5"
    "beautifulsoup4==4.13.3"
    "bitarray==3.3.0"
    "blinker==1.9.0"
    "certifi==2025.1.31"
    "charset-normalizer==3.4.1"
    "colbert-ai==0.2.21"
    "colorama==0.4.6"
    "contourpy==1.3.1"
    "cycler==0.12.1"
    "dataclasses-json==0.6.7"
    "datasets==3.5.0"
    "deprecated==1.2.18"
    "dill==0.3.8"
    "dirtyjson==1.0.8"
    "distro==1.9.0"
    "exceptiongroup==1.2.2"
    "faiss-gpu==1.7.2"
    "filelock==3.13.1"
    "filetype==1.2.0"
    "flask==3.1.0"
    "fonttools==4.56.0"
    "frozenlist==1.5.0"
    "fsspec==2024.6.1"
    "future==1.0.0"
    "gensim==4.3.3"
    "git-python==1.0.3"
    "gitdb==4.0.12"
    "gitpython==3.1.44"
    "graspologic==3.4.1"
    "graspologic-native==1.2.5"
    "greenlet==3.1.1"
    "griffe==1.7.2"
    "h11==0.14.0"
    "httpcore==1.0.7"
    "httpx==0.27.2"
    "huggingface-hub==0.30.1"
    "hyppo==0.4.0"
    "idna==3.10"
    "igraph==0.11.8"
    "itsdangerous==2.2.0"
    "jinja2==3.1.4"
    "jiter==0.9.0"
    "joblib==1.4.2"
    "kiwisolver==1.4.8"
    "lazy-object-proxy==1.10.0"
    "llama-cloud==0.1.17"
    "llama-cloud-services==0.6.9"
    "llama-index==0.12.28"
    "llama-index-agent-openai==0.4.6"
    "llama-index-cli==0.4.1"
    "llama-index-core==0.12.28"
    "llama-index-embeddings-huggingface==0.5.2"
    "llama-index-embeddings-ollama==0.6.0"
    "llama-index-embeddings-openai==0.3.1"
    "llama-index-indices-managed-llama-cloud==0.6.11"
    "llama-index-legacy==0.9.48.post4"
    "llama-index-llms-openai==0.3.30"
    "llama-index-multi-modal-llms-openai==0.4.3"
    "llama-index-program-openai==0.3.1"
    "llama-index-question-gen-openai==0.3.0"
    "llama-index-readers-file==0.4.7"
    "llama-index-readers-llama-parse==0.4.0"
    "llama-index-vector-stores-faiss==0.3.0"
    "llama-index-vector-stores-postgres==0.4.2"
    "llama-parse==0.6.4.post1"
    "llvmlite==0.44.0"
    "loguru==0.7.3"
    "markupsafe==2.1.5"
    "marshmallow==3.26.1"
    "matplotlib==3.10.1"
    "mauve-text==0.4.0"
    "mpmath==1.3.0"
    "multidict==6.2.0"
    "multiprocess==0.70.16"
    "mypy-extensions==1.0.0"
    "nest-asyncio==1.6.0"
    "networkx==3.3"
    "ninja==1.11.1.4"
    "nltk==3.9.1"
    "numba==0.61.0"
    "numpy==1.26.4"
    "nvidia-cublas-cu12==12.4.5.8"
    "nvidia-cuda-cupti-cu12==12.4.127"
    "nvidia-cuda-nvrtc-cu12==12.4.127"
    "nvidia-cuda-runtime-cu12==12.4.127"
    "nvidia-cudnn-cu12==9.1.0.70"
    "nvidia-cufft-cu12==11.2.1.3"
    "nvidia-curand-cu12==10.3.5.147"
    "nvidia-cusolver-cu12==11.6.1.9"
    "nvidia-cusparse-cu12==12.3.1.170"
    "nvidia-cusparselt-cu12==0.6.2"
    "nvidia-nccl-cu12==2.21.5"
    "nvidia-nvjitlink-cu12==12.4.127"
    "nvidia-nvtx-cu12==12.4.127"
    "ollama==0.3.1"
    "openai==1.70.0"
    "pandas==2.2.3"
    "patsy==1.0.1"
    "pcst-fast==1.0.10"
    "pgvector==0.4.0"
    "pillow==11.0.0"
    "platformdirs==4.3.7"
    "pot==0.9.5"
    "propcache==0.3.1"
    "psycopg2-binary==2.9.10"
    "pyarrow==19.0.1"
    "pybind11==2.13.6"
    "pydantic==2.11.1"
    "pydantic-core==2.33.0"
    "pyfiglet==1.0.2"
    "pynndescent==0.5.13"
    "pyparsing==3.2.3"
    "pypdf==5.4.0"
    "python-dateutil==2.9.0.post0"
    "python-dotenv==1.1.0"
    "pytz==2025.2"
    "pyyaml==6.0.2"
    "regex==2024.11.6"
    "requests==2.32.3"
    "rouge-score==0.1.2"
    "safetensors==0.5.3"
    "scikit-learn==1.6.1"
    "scipy==1.12.0"
    "seaborn==0.13.2"
    "sentence-transformers==4.0.1"
    "six==1.17.0"
    "smart-open==7.1.0"
    "smmap==5.0.2"
    "sniffio==1.3.1"
    "soupsieve==2.6"
    "sqlalchemy==2.0.40"
    "statsmodels==0.14.4"
    "striprtf==0.0.26"
    "sympy==1.13.1"
    "tenacity==8.5.0"
    "texttable==1.7.0"
    "threadpoolctl==3.6.0"
    "tiktoken==0.9.0"
    "tokenizers==0.21.1"
    "torch==2.6.0"
    "tqdm==4.67.1"
    "transformers==4.49.0"
    "triton==3.2.0"
    "typing-extensions==4.12.2"
    "typing-inspect==0.9.0"
    "typing-inspection==0.4.0"
    "tzdata==2025.2"
    "ujson==5.10.0"
    "umap==0.1.1"
    "umap-learn==0.5.7"
    "urllib3==2.3.0"
    "werkzeug==3.1.3"
    "wrapt==1.17.2"
    "xxhash==3.5.0"
    "yarl==1.18.3"
)

# Counters for tracking installation results
total_packages=${#packages[@]}
installed_count=0
failed_count=0
failed_packages=()

echo "Total packages to install: $total_packages"
echo ""

# Install each package individually with error handling
for package in "${packages[@]}"; do
    echo "Installing $package..."
    
    if pip install "$package"; then
        echo "✅ Successfully installed $package"
        ((installed_count++))
    else
        echo "❌ Failed to install $package - skipping..."
        failed_packages+=("$package")
        ((failed_count++))
    fi
    
    echo ""
done

echo "=========================================="
echo "Installation Summary:"
echo "Total packages: $total_packages"
echo "Successfully installed: $installed_count"
echo "Failed to install: $failed_count"
echo ""

if [ $failed_count -gt 0 ]; then
    echo "Failed packages:"
    for failed_pkg in "${failed_packages[@]}"; do
        echo "  - $failed_pkg"
    done
    echo ""
fi

echo "Installation process completed!" 