dataset="mini_cs"
similarity_mode="nodes_only"
use_subset_averaging=true
target_reduction_percent=0.20
max_neighbors=10
batch_size=128
node_weight=0.5
neighbor_weight=0.5

graphml_path="Result/${dataset}/rkg_graph/graph_storage/graph_storage_nx_data.graphml"
node_data_path="Result/${dataset}/rkg_graph/k_means/${dataset}_kmeans_similar_nodes.json"
cluster_map_path="Result/${dataset}/rkg_graph/k_means/${dataset}_kmeans10_cluster_map.json"
output_dir="Result/${dataset}/rkg_graph/node_neighbors"
cache_dir="Result/${dataset}/rkg_graph/k_means"

python denoise_kg/similar_percentage.py \
    --dataset_name $dataset \
    --similarity_mode $similarity_mode \
    --use_subset_averaging $use_subset_averaging \
    --target_reduction_percent $target_reduction_percent \
    --max_neighbors $max_neighbors \
    --batch_size $batch_size \
    --node_weight $node_weight \
    --neighbor_weight $neighbor_weight \
    --graphml_path $graphml_path \
    --node_data_path $node_data_path \
    --cluster_map_path $cluster_map_path \
    --output_dir $output_dir \
    --cache_dir $cache_dir
