#!/bin/bash

dataset_name="mini_cs"
similarity=20
graph_path="Result/${dataset_name}/rkg_graph/graph_storage/graph_storage_nx_data.graphml"
similar_nodes_path="Result/${dataset_name}/rkg_graph/node_neighbors/${dataset_name}_${similarity}.0pct_pairs_subset_True_nodes_only.json"
output_path="Result/${dataset_name}/rkg_graph/graph_storage/graph_storage_nx_data_nodes_${similarity}.0.graphml"
threshold_edge_reason=0.65

python denoise_kg/merge.py \
    --similarity $similarity \
    --dataset_name $dataset_name \
    --graph_path $graph_path \
    --similar_nodes_path $similar_nodes_path \
    --output_path $output_path \
    --threshold_edge_reason $threshold_edge_reason
