#!/usr/bin/env bash

CLIENT_NUM=$1
WORKER_NUM=$2
MODEL=$3
DISTRIBUTION=$4
ALPHA=$5
ROUND=$6
EPOCH=$7
BATCH_SIZE=$8
LR=$9
DATASET=${10}
DATA_DIR=${11}
CLIENT_OPTIMIZER=${12}
CI=${13}
SSL=${14}
PER=${15}
GPU_MAPPING=${16}
RUN_ID=${17}
PSSL_LAMBDA=${18}
EVAL=${19}
USING_PER_DATA=${20}

PROCESS_NUM=`expr $WORKER_NUM + 1`
echo $PROCESS_NUM

hostname > mpi_host_file

mpirun -np $PROCESS_NUM -hostfile ./mpi_host_file python3 ./main_fedssl.py \
  --gpu_mapping_file "gpu_mapping.yaml" \
  --gpu_mapping_key $GPU_MAPPING \
  --model $MODEL \
  --dataset $DATASET \
  --data_dir $DATA_DIR \
  --ssl_method $SSL \
  --pssl_optimizer $PER \
  --partition_method $DISTRIBUTION  \
  --partition_alpha $ALPHA \
  --client_num_in_total $CLIENT_NUM \
  --client_num_per_round $WORKER_NUM \
  --comm_round $ROUND \
  --epochs $EPOCH \
  --client_optimizer $CLIENT_OPTIMIZER \
  --batch_size $BATCH_SIZE \
  --lr $LR \
  --perFedAvg_is_first_order \
  --ci $CI \
  --run_id $RUN_ID \
  --pssl_lambda $PSSL_LAMBDA \
  --ssl_is_linear_eval $EVAL \
  --using_personalized_data $USING_PER_DATA
#  --gpu_mapping_file "None" \
#  --gpu_mapping_key "mapping_1p_pergpu" \
#  --gpu_mapping_file "gpu_mapping.yaml" \


#python main_centralized_linear_eval_cifar.py \
#--arch resnet18 \
#--num_cls 10 \
#--batch_size 256 \
#--lr 30.0 \
#--weight_decay 0.0 \
#--pretrained \
#./checkpoint/resnet18_cifar_fedssl_best_acc.pth \
#--data_dir "./../../../data/cifar10"
