## Installation
We reuse the FedML Framework to develop SSFL.

http://doc.fedml.ai/#/installation-distributed-computing

## Run Experiments

###  CIFAR-10 (alpha = 0.1) SSL Training

#####  CIFAR-10 (personalized dataset), FedAvg, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 10000


# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.3 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.001 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.0001 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg
```

##### CIFAR-10 (personalized dataset), perFedAvg, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.03

```
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.3 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg

# the best lr = 0.03
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 201505230640 1 0

# after bug fix:
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 1001

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg
```

##### CIFAR-10 (personalized dataset), pFedMe, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam pFedMe mapping_g1lmd3_last_4_gpu

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam pFedMe
```

##### CIFAR-10 (personalized dataset), Ditto, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto mapping_g1lmd2_1st_4_gpu

# lambda4-1.sh
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto mapping_g1lmd3_last_4_gpu 052301 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto mapping_g1lmd2_1st_4_gpu 052302 0.1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto mapping_g1lmd2_1st_4_gpu 052303 0.01

# running


# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.3 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam Ditto mapping_g1lmd3_last_4_gpu

```

##### CIFAR-10 (personalized dataset), perSSL, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
# good
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSSL mapping_g1lmd2_last_4_gpu

# running
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.3 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSSL mapping_g1lmd3_1st_4_gpu

# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSSL
```

##### CIFAR-10 (personalized dataset), perSSL, perSimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
# running at Chaoyang's server
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam mapping_g1lmd3_1st_4_gpu 2000

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam
```

##### CIFAR-10 (personalized dataset), perSSL, perSimSiam2, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_last_4_gpu 88802

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_1st_4_gpu 88803
# 1.sh
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_last_4_gpu 88804

# Running 1.sh (lambda4)
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_last_4_gpu 880525043211 0.1 0 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam2 mapping_default 880525043211 0.1 0 1

```


#### CIFAR-10 (alpha = 0.5) SSL Training

##### CIFAR-10 (personalized dataset), FedAvg, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1

```
# best FedAvg
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 90011

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_last_4_gpu 90012
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg_LocalAdaptation mapping_g1lmd3_1st_4_gpu 90013

# perSimSiam
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam mapping_g1lmd3_1st_4_gpu 90001
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam mapping_g1lmd3_last_4_gpu 90002

# perFedAvg
# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 90003
# not working
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_last_4_gpu 90004

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 90005
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_last_4_gpu 90006

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.5 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 90007
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_last_4_gpu 90008


# Meta-ResNet
# 2.sh
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 880525043222 1 0 1

```

##### Global Model Training with Global Test Data (FedAvg)
```
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar homo 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 880525043201 1 0 0
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar hetero 0.1 800 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_last_4_gpu 880525043202 1 0 0
```


##### CIFAR-10 SSL Evaluation
All clients' models
```
sh run_per_eval.sh 0 1 FedAvg 90013
sh run_per_eval.sh 0 1 perFedAvg 201505230640
sh run_per_eval.sh 1 1 Ditto 52301
sh run_per_eval.sh 2 1 perSimSiam2 1221

sh run_per_eval.sh 3 0.1 FedAvg 90013
sh run_per_eval.sh 4 0.1 perFedAvg 201505230640
sh run_per_eval.sh 5 0.1 Ditto 52301
sh run_per_eval.sh 6 0.1 perSimSiam2 1221

```

Single model
```
python main_centralized_linear_eval_cifar.py --data_dir ./../../../data/cifar10 --pretrained ./checkpoint/fedavg_simsiam.pth
```

Distributed
```
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 200 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perFedAvg mapping_g1lmd3_1st_4_gpu 90006 1 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 200 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 90012 1 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 200 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam FedAvg_LocalAdaptation mapping_g1lmd3_1st_4_gpu 90013 1 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 200 1 32 0.1 cifar10 "./../../../data/cifar10" sgd 0 simsiam perSimSiam mapping_g1lmd3_1st_4_gpu 2000 1 1


```



#### GLD-23k SSL Training

##### GLD-23K (personalized dataset), FedAvg, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1
``` 4.sh, lambda3
# image size = 32
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 999001 1 0 1

# image size = 224, batch_size = 2 * 128
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888001 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 1 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888002 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.3 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888003 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888004 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.01 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888005 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.003 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888006 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.001 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888007 1 0 1


sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 3 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888011 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 10 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888022 1 0 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 30 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888033 1 0 1

# 6.sh, lambda3
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_g1lmd3_1st_4_gpu 99002 1 0 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 3000 1 32 10 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888801 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 3000 1 32 3 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888802 1 0 1

sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 10 gld23k_per "/home/chaoyanghe/sourcecode/fedml.ai/data/gld" sgd 0 simsiam FedAvg mapping_config8_10 888022 1 0 1

# k=10
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 10 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 8888022 1 0 1
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 3 gld23k_per "./../../../data/gld" sgd 0 simsiam FedAvg mapping_config8_10 8888011 1 0 1

```

##### GLD-23K (personalized dataset), perFedAvg, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1
``` 5.sh, lambda3
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 gld23k_per "./../../../data/gld" sgd 0 simsiam perFedAvg mapping_g1lmd3_last_4_gpu 99101 1 0 1

# 0.sh, lambda3
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 gld23k_per "./../../../data/gld" sgd 0 simsiam perFedAvg mapping_g1lmd3_last_4_gpu 99102 1 0 1
```

##### GLD-23K (personalized dataset), Ditto, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1
``` 3.sh lambda4
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 gld23k_per "./../../../data/gld" sgd 0 simsiam Ditto mapping_g1lmd3_1st_4_gpu 99201 1 0 1

# 5.sh lambda4
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 gld23k_per "./../../../data/gld" sgd 0 simsiam Ditto mapping_g1lmd3_1st_4_gpu 99202 1 0 1
```

##### GLD-23K (personalized dataset), perSimSiam2, SimSiam, client number=10, worker number=10, batch size = 32 * 8, learning rate = 0.1
``` 4.sh lambda4
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.1 gld23k_per "./../../../data/gld" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_last_4_gpu 99301 1 0 1

# 6.sh lambda4
sh run_fedssl_distributed_pytorch.sh 10 10 resnet18_cifar lda 0.1 800 1 32 0.03 gld23k_per "./../../../data/gld" sgd 0 simsiam perSimSiam2 mapping_g1lmd3_1st_4_gpu 99302 1 0 1
```
