#!/bin/bash
"""
Training script for SteerCLR steering vectors.

This script provides an easy way to train steering vectors with different configurations.
Modify the CONFIG variable below to use different configurations.

Usage:
    ./scripts/train.sh                    # Train with demo config
    ./scripts/train.sh qwen_config.yaml   # Train with specific config
"""

set -e

# Configuration
if [ $# -eq 0 ]; then
    CONFIG="configs/qwen_config.yaml"
else
    CONFIG="$1"
fi

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PROJECT_ROOT="$(dirname "$SCRIPT_DIR")"

echo "Starting SteerCLR training..."
echo "Configuration: $CONFIG"
echo "Project root: $PROJECT_ROOT"

# Change to project root
cd "$PROJECT_ROOT"

# Check if config file exists
if [[ ! -f "$CONFIG" ]]; then
    echo "Error: Configuration file not found: $CONFIG"
    echo "Available configs:"
    ls -la configs/
    exit 1
fi

# Check if required directories exist
if [[ ! -d "src" ]]; then
    echo "Error: src directory not found. Please run from project root."
    exit 1
fi

# Set up Python path and run training
export PYTHONPATH="$PROJECT_ROOT/src:$PYTHONPATH"

echo ""
echo "Running training with config: $CONFIG"
echo "Press Ctrl+C to interrupt training and save current progress."
echo ""

# Run training
python scripts/train.py --config "$CONFIG"

echo ""
echo "Training completed! Check the outputs/ directory for results."
