import numpy as np
import math

from sklearn.svm import SVC
from sklearn.metrics.pairwise import rbf_kernel
from collections import Counter
from sklearn.metrics.pairwise import euclidean_distances


'''k-NN classifier'''
def kNN(k, X_test, y_train):
    labels = []
    for distances in X_test:
        # create a list with an index of train data, arranged in order of decreasing value in the distance list
        sorted_train_indexes = np.argsort(np.array(distances))
        # extract the labels of the k train data closest to the test, based on the index list
        sorted_k_labels = y_train[sorted_train_indexes][:k]
        # extract the most labels in sorted_k_labels
        label = Counter(sorted_k_labels).most_common(1)[0][0]
        labels.append(label)
    return labels

'''SVM classifier'''
def SVM(SVC_kernel, SVC_C, X_train, y_train, X_test, y_test, name):
    if SVC_kernel == 'precomputed':
        gs = SVC(C=SVC_C, kernel='precomputed').fit(X_train, y_train)
        return gs.predict(X_test)

    else:
        gs = SVC(C=SVC_C, kernel=SVC_kernel,gamma='scale').fit(X_train, y_train)
        return gs.predict(X_test)

'''Graph predictor'''
def Graph_predictor(X_train, y_train, X_test, y_test, mode='s', SVC_kernel='rbf', SVC_C=100, k=1, name='MUTAG'):
    if mode == 's':
        return SVM(SVC_kernel, SVC_C, X_train, y_train, X_test, y_test, name)
    else:
        return kNN(k, np.array(X_test), np.array(y_train))
