from graph_visualizer import *
from networkx.readwrite import json_graph
import json
import networkx as nx
import sys
import re


def get_node_num(text):
    return re.findall("(?<=\().+?(?=\))", text)[0]

def search_graph(G, dict_tree, current_key, No, label={}):
    current_dict_tree = dict_tree[current_key]
    node_num = get_node_num(current_key)
    current_num = node_num+'['+str(No)+']'
    label[current_num] = int(current_key[:current_key.find('(')])
    for next_key in current_dict_tree.keys():
        next_num = get_node_num(next_key)+'['+str(No+1)+']'
        G.add_edge(current_num, next_num)
        G, No, label = search_graph(G, current_dict_tree, next_key, No+1, label)
    return G, No, label

def dictionary_tree_visualizer(dict_tree, name, num):

    graph = nx.Graph()
    for first_key in dict_tree:
        graph.add_node(get_node_num(first_key)+'[0]')

    graph, _, label = search_graph(graph, dict_tree, list(dict_tree.keys())[0], 0)
    nx.set_node_attributes(graph, label, 'x')

    draw_graph(graph,name='tree',graph_label=name,
        node_labels=True,num=num,vmin=-2,vmax=3,with_node_labels=True)

