import os
import subprocess
import logging

datasets = ['MUTAG', 'PTC_FM', 'PTC_MR', 'PROTEINS', 'IMDB-BINARY', 'IMDB-MULTI']

if not os.path.isdir('./Log'):
    os.makedirs('./Log', exist_ok=True)

for dataset in datasets:
    logging.basicConfig(filename=f'./Log/{dataset}.log', level=logging.DEBUG, format='%(asctime)s: %(message)s')

    proc = subprocess.Popen(['python3','main.py','--dataset',dataset], stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    while True:
        rcode = proc.poll()
        if rcode is None:
            line = proc.stdout.readline().strip()
            print(line.decode())
            logging.info(line)
        else:
            break
