"""
Provides the base `Model` class and related functionality for creating and managing machine learning models.

The `Model` class is the core abstraction for representing a machine learning model. It provides methods for training, evaluating, and making predictions with the model.

Subclasses of `Model` should implement the necessary logic for their specific model type, such as defining the model architecture, loss function, and training procedure.
"""
import importlib
import os
import os.path as osp
from utils.model_register import import_models, Register

model_dict = Register('model_dict')

import_models(osp.dirname(__file__), 'models')
import_models(osp.join(osp.dirname(osp.dirname(osp.abspath(__file__))), 'experiment'), 'experiment')
