import json


class SystemPromptBuilder:

    def __init__(self, template_path):
        self.system_prompt = None
        self.final_prompt = None
        self.user_prompt = None
        self.api_prompt = None
        self.intent_prompt = None
        self._load_template(template_path)

    def _load_template(self, template_path):
        with open(template_path, 'r') as file:
            words = file.read()
            self.system_prompt = words.split('<split>\n')[0]
            self.final_prompt = words.split('<split>\n')[1]
            self.user_prompt = words.split('<split>\n')[2]
            self.api_prompt = words.split('<split>\n')[3]
            self.intent_prompt = words.split('<split>\n')[4]
    def build(self, candidate_info):
        return self.system_prompt + candidate_info


if __name__ == '__main__':
    tem_path = ("/Users/..../prompt.txt")
    sp = SystemPromptBuilder(tem_path)
