from threading import Lock
from collections import defaultdict


class PathStateManager:

    def __init__(self):
        self.state = {}
        self.lock = Lock()

    def init_path(self, path_id):
        with self.lock:
            self.state[path_id] = {
                "collected_params": {},
                "called_apis": defaultdict(list),
                "failed_apis": defaultdict(list),
                "status": "pending",
                "result": []
            }

    def update_api_status(self, path_id, api_result, target_api):
        with self.lock:
            if api_result["status"] == "success":
                self.state[path_id]["collected_params"].update({target_api: api_result["message"]})
                self.state[path_id]["called_apis"][target_api] = api_result["message"]
            else:
                self.state[path_id]["failed_apis"][target_api].append(api_result["message"])
                self.state[path_id]['retry_count'][target_api] += 1