import pandas as pd


class APIConfigLoader:

    def __init__(self, csv_path):
        self._load_config(csv_path)

    def _load_config(self, path):
        df = pd.read_csv(path)
        df['all_info'] = df.apply(lambda x: {
            'description': x['description'],
            'input_params': x['input_params'],
            'output_params': x['output_params']
        }, axis=1)
        self.api_library = df.set_index('api_name')['all_info'].to_dict()