import numpy as np
from sentence_transformers import SentenceTransformer


class APISemanticRecaller:

    def __init__(self, top_k, api_library):
        self.top_k = top_k
        self.model = SentenceTransformer('BAAI/bge-base-en-v1.5')
        self.api_library = api_library
        self._init_embeddings()

    def _init_embeddings(self):
        self.api_embeddings = self.model.encode([
            f"{name} API: {info}"
            for name, info in self.api_library.items()
        ])

    def retrieve(self, query):
        query_emb = self.model.encode(query)
        scores = np.dot(query_emb, self.api_embeddings.T)
        return [api for _, api in sorted(zip(scores, self.api_library), reverse=True)[:self.top_k]]
