import logging, datetime
from logging.handlers import RotatingFileHandler
from colorama import Fore, Style
from enum import Enum


class ProcessPhase(Enum):
    QUERY_PARSING = "query_parsing"
    LLM_INFERENCE = "llm_inference"
    API_EXECUTION = "api_execution"
    RESULT_AGGREGATION = "result_aggregation"


class LogConfig:
    _configured = False

    @classmethod
    def configure(cls):
        if not cls._configured:
            logger = logging.getLogger('FunctionCallAgent')
            logger.setLevel(logging.DEBUG)

            file_handler = RotatingFileHandler(
                '/Users/logging/'
                'function_call_agent_{time}.log'.format(time=str(datetime.datetime.now()).split('.')[0]),
                maxBytes=10 * 1024 * 1024,  # 10MB
                backupCount=5,
                encoding='utf-8',
                mode='w'
            )
            file_formatter = logging.Formatter(
                '%(asctime)s | %(levelname)-8s | %(module)s.%(funcName)s | %(message)s'
            )
            file_handler.setFormatter(file_formatter)

            console_handler = logging.StreamHandler()
            console_formatter = logging.Formatter(
                f'{Fore.CYAN}%(asctime)s{Style.RESET_ALL} | '
                f'%(levelname)-8s | '
                f'{Fore.GREEN}%(module)s.%(funcName)s{Style.RESET_ALL} | '
                f'%(message)s'
            )
            console_handler.setFormatter(console_formatter)

            logger.addHandler(file_handler)
            logger.addHandler(console_handler)
            cls._configured = True



