import json, sys
from openai import OpenAI



class LLMClient:
    """LLM"""

    def __init__(self, model_name):
        self.model_name = model_name

    def get_response(self, messages):

        openai_api_key = "EMPTY"
        openai_api_base = ""
        client = OpenAI(
            api_key=openai_api_key,
            base_url=openai_api_base,
        )
        chat_completion = client.chat.completions.create(
            messages=messages,
            model="qwen25-32b-native-v1",  # qwen25-32b-instruct、qwen25-14b-native
            max_tokens=1024,
            stop=["<|im_end|>", "<|endoftext|>"],
            stream=False,
            extra_body={"chat_template_kwargs": {"enable_thinking": False}},
        )

        try:
            result = json.loads(chat_completion.json()).get('choices')[0].get('message').get('content')
        except:
            result = json.loads(chat_completion.json()).get('choices')[0].get('message').get('reasoning_content')
        return result

    @staticmethod
    def parse_response(raw_response):
        if '</think>' in raw_response:
            if "```json" in raw_response:
                response = raw_response.split('</think>')[1].replace("```json", '').replace('```', '')
            else:
                response = raw_response.split('</think>')[1].replace('\n', '').replace('```', '')

        else:
            if "```json" in raw_response:
                response = raw_response.split("```json\n")[1].replace('```', '').replace('json', '')
            elif "'[{\n'" in raw_response:
                response = '[{\n' + raw_response.replace('```', '').replace('json', '').split('[{\n')[1]
            else:
                response = raw_response
        try:
            response = json.loads(response)
        except Exception as e:
            try:
                response = eval(response)
            except Exception as e:
                response = response
        return response


if __name__ == '__main__':
    model = LLMClient('gpt_4o')
    print(model.get_response([{"role": "system", "content": ""},
                        {"role": "user", "content": "Hello"}]))
