"""
Copyright (2023) Bytedance Ltd. and/or its affiliates

Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0 

Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
"""

import copy
from .lvis_v1_categories import LVIS_CATEGORIES

COCO_CATEGORIES = [
    {"color": [220, 20, 60], "isthing": 1, "id": 1, "name": "person"},
    {"color": [119, 11, 32], "isthing": 1, "id": 2, "name": "bicycle"},
    {"color": [0, 0, 142], "isthing": 1, "id": 3, "name": "car"},
    {"color": [0, 0, 230], "isthing": 1, "id": 4, "name": "motorcycle"},
    {"color": [106, 0, 228], "isthing": 1, "id": 5, "name": "airplane"},
    {"color": [0, 60, 100], "isthing": 1, "id": 6, "name": "bus"},
    {"color": [0, 80, 100], "isthing": 1, "id": 7, "name": "train"},
    {"color": [0, 0, 70], "isthing": 1, "id": 8, "name": "truck"},
    {"color": [0, 0, 192], "isthing": 1, "id": 9, "name": "boat"},
    {"color": [250, 170, 30], "isthing": 1, "id": 10, "name": "traffic light"},
    {"color": [100, 170, 30], "isthing": 1, "id": 11, "name": "fire hydrant"},
    {"color": [220, 220, 0], "isthing": 1, "id": 13, "name": "stop sign"},
    {"color": [175, 116, 175], "isthing": 1, "id": 14, "name": "parking meter"},
    {"color": [250, 0, 30], "isthing": 1, "id": 15, "name": "bench"},
    {"color": [165, 42, 42], "isthing": 1, "id": 16, "name": "bird"},
    {"color": [255, 77, 255], "isthing": 1, "id": 17, "name": "cat"},
    {"color": [0, 226, 252], "isthing": 1, "id": 18, "name": "dog"},
    {"color": [182, 182, 255], "isthing": 1, "id": 19, "name": "horse"},
    {"color": [0, 82, 0], "isthing": 1, "id": 20, "name": "sheep"},
    {"color": [120, 166, 157], "isthing": 1, "id": 21, "name": "cow"},
    {"color": [110, 76, 0], "isthing": 1, "id": 22, "name": "elephant"},
    {"color": [174, 57, 255], "isthing": 1, "id": 23, "name": "bear"},
    {"color": [199, 100, 0], "isthing": 1, "id": 24, "name": "zebra"},
    {"color": [72, 0, 118], "isthing": 1, "id": 25, "name": "giraffe"},
    {"color": [255, 179, 240], "isthing": 1, "id": 27, "name": "backpack"},
    {"color": [0, 125, 92], "isthing": 1, "id": 28, "name": "umbrella"},
    {"color": [209, 0, 151], "isthing": 1, "id": 31, "name": "handbag"},
    {"color": [188, 208, 182], "isthing": 1, "id": 32, "name": "tie"},
    {"color": [0, 220, 176], "isthing": 1, "id": 33, "name": "suitcase"},
    {"color": [255, 99, 164], "isthing": 1, "id": 34, "name": "frisbee"},
    {"color": [92, 0, 73], "isthing": 1, "id": 35, "name": "skis"},
    {"color": [133, 129, 255], "isthing": 1, "id": 36, "name": "snowboard"},
    {"color": [78, 180, 255], "isthing": 1, "id": 37, "name": "sports ball"},
    {"color": [0, 228, 0], "isthing": 1, "id": 38, "name": "kite"},
    {"color": [174, 255, 243], "isthing": 1, "id": 39, "name": "baseball bat"},
    {"color": [45, 89, 255], "isthing": 1, "id": 40, "name": "baseball glove"},
    {"color": [134, 134, 103], "isthing": 1, "id": 41, "name": "skateboard"},
    {"color": [145, 148, 174], "isthing": 1, "id": 42, "name": "surfboard"},
    {"color": [255, 208, 186], "isthing": 1, "id": 43, "name": "tennis racket"},
    {"color": [197, 226, 255], "isthing": 1, "id": 44, "name": "bottle"},
    {"color": [171, 134, 1], "isthing": 1, "id": 46, "name": "wine glass"},
    {"color": [109, 63, 54], "isthing": 1, "id": 47, "name": "cup"},
    {"color": [207, 138, 255], "isthing": 1, "id": 48, "name": "fork"},
    {"color": [151, 0, 95], "isthing": 1, "id": 49, "name": "knife"},
    {"color": [9, 80, 61], "isthing": 1, "id": 50, "name": "spoon"},
    {"color": [84, 105, 51], "isthing": 1, "id": 51, "name": "bowl"},
    {"color": [74, 65, 105], "isthing": 1, "id": 52, "name": "banana"},
    {"color": [166, 196, 102], "isthing": 1, "id": 53, "name": "apple"},
    {"color": [208, 195, 210], "isthing": 1, "id": 54, "name": "sandwich"},
    {"color": [255, 109, 65], "isthing": 1, "id": 55, "name": "orange"},
    {"color": [0, 143, 149], "isthing": 1, "id": 56, "name": "broccoli"},
    {"color": [179, 0, 194], "isthing": 1, "id": 57, "name": "carrot"},
    {"color": [209, 99, 106], "isthing": 1, "id": 58, "name": "hot dog"},
    {"color": [5, 121, 0], "isthing": 1, "id": 59, "name": "pizza"},
    {"color": [227, 255, 205], "isthing": 1, "id": 60, "name": "donut"},
    {"color": [147, 186, 208], "isthing": 1, "id": 61, "name": "cake"},
    {"color": [153, 69, 1], "isthing": 1, "id": 62, "name": "chair"},
    {"color": [3, 95, 161], "isthing": 1, "id": 63, "name": "couch"},
    {"color": [163, 255, 0], "isthing": 1, "id": 64, "name": "potted plant"},
    {"color": [119, 0, 170], "isthing": 1, "id": 65, "name": "bed"},
    {"color": [0, 182, 199], "isthing": 1, "id": 67, "name": "dining table"},
    {"color": [0, 165, 120], "isthing": 1, "id": 70, "name": "toilet"},
    {"color": [183, 130, 88], "isthing": 1, "id": 72, "name": "tv"},
    {"color": [95, 32, 0], "isthing": 1, "id": 73, "name": "laptop"},
    {"color": [130, 114, 135], "isthing": 1, "id": 74, "name": "mouse"},
    {"color": [110, 129, 133], "isthing": 1, "id": 75, "name": "remote"},
    {"color": [166, 74, 118], "isthing": 1, "id": 76, "name": "keyboard"},
    {"color": [219, 142, 185], "isthing": 1, "id": 77, "name": "cell phone"},
    {"color": [79, 210, 114], "isthing": 1, "id": 78, "name": "microwave"},
    {"color": [178, 90, 62], "isthing": 1, "id": 79, "name": "oven"},
    {"color": [65, 70, 15], "isthing": 1, "id": 80, "name": "toaster"},
    {"color": [127, 167, 115], "isthing": 1, "id": 81, "name": "sink"},
    {"color": [59, 105, 106], "isthing": 1, "id": 82, "name": "refrigerator"},
    {"color": [142, 108, 45], "isthing": 1, "id": 84, "name": "book"},
    {"color": [196, 172, 0], "isthing": 1, "id": 85, "name": "clock"},
    {"color": [95, 54, 80], "isthing": 1, "id": 86, "name": "vase"},
    {"color": [128, 76, 255], "isthing": 1, "id": 87, "name": "scissors"},
    {"color": [201, 57, 1], "isthing": 1, "id": 88, "name": "teddy bear"},
    {"color": [246, 0, 122], "isthing": 1, "id": 89, "name": "hair drier"},
    {"color": [191, 162, 208], "isthing": 1, "id": 90, "name": "toothbrush"},
    {"color": [255, 255, 128], "isthing": 0, "id": 92, "name": "banner"},
    {"color": [147, 211, 203], "isthing": 0, "id": 93, "name": "blanket"},
    {"color": [150, 100, 100], "isthing": 0, "id": 95, "name": "bridge"},
    {"color": [168, 171, 172], "isthing": 0, "id": 100, "name": "cardboard"},
    {"color": [146, 112, 198], "isthing": 0, "id": 107, "name": "counter"},
    {"color": [210, 170, 100], "isthing": 0, "id": 109, "name": "curtain"},
    {"color": [92, 136, 89], "isthing": 0, "id": 112, "name": "door-stuff"},
    {"color": [218, 88, 184], "isthing": 0, "id": 118, "name": "floor-wood"},
    {"color": [241, 129, 0], "isthing": 0, "id": 119, "name": "flower"},
    {"color": [217, 17, 255], "isthing": 0, "id": 122, "name": "fruit"},
    {"color": [124, 74, 181], "isthing": 0, "id": 125, "name": "gravel"},
    {"color": [70, 70, 70], "isthing": 0, "id": 128, "name": "house"},
    {"color": [255, 228, 255], "isthing": 0, "id": 130, "name": "light"},
    {"color": [154, 208, 0], "isthing": 0, "id": 133, "name": "mirror-stuff"},
    {"color": [193, 0, 92], "isthing": 0, "id": 138, "name": "net"},
    {"color": [76, 91, 113], "isthing": 0, "id": 141, "name": "pillow"},
    {"color": [255, 180, 195], "isthing": 0, "id": 144, "name": "platform"},
    {"color": [106, 154, 176], "isthing": 0, "id": 145, "name": "playingfield"},
    {"color": [230, 150, 140], "isthing": 0, "id": 147, "name": "railroad"},
    {"color": [60, 143, 255], "isthing": 0, "id": 148, "name": "river"},
    {"color": [128, 64, 128], "isthing": 0, "id": 149, "name": "road"},
    {"color": [92, 82, 55], "isthing": 0, "id": 151, "name": "roof"},
    {"color": [254, 212, 124], "isthing": 0, "id": 154, "name": "sand"},
    {"color": [73, 77, 174], "isthing": 0, "id": 155, "name": "sea"},
    {"color": [255, 160, 98], "isthing": 0, "id": 156, "name": "shelf"},
    {"color": [255, 255, 255], "isthing": 0, "id": 159, "name": "snow"},
    {"color": [104, 84, 109], "isthing": 0, "id": 161, "name": "stairs"},
    {"color": [169, 164, 131], "isthing": 0, "id": 166, "name": "tent"},
    {"color": [225, 199, 255], "isthing": 0, "id": 168, "name": "towel"},
    {"color": [137, 54, 74], "isthing": 0, "id": 171, "name": "wall-brick"},
    {"color": [135, 158, 223], "isthing": 0, "id": 175, "name": "wall-stone"},
    {"color": [7, 246, 231], "isthing": 0, "id": 176, "name": "wall-tile"},
    {"color": [107, 255, 200], "isthing": 0, "id": 177, "name": "wall-wood"},
    {"color": [58, 41, 149], "isthing": 0, "id": 178, "name": "water-other"},
    {"color": [183, 121, 142], "isthing": 0, "id": 180, "name": "window-blind"},
    {"color": [255, 73, 97], "isthing": 0, "id": 181, "name": "window-other"},
    {"color": [107, 142, 35], "isthing": 0, "id": 184, "name": "tree-merged"},
    {"color": [190, 153, 153], "isthing": 0, "id": 185, "name": "fence-merged"},
    {"color": [146, 139, 141], "isthing": 0, "id": 186, "name": "ceiling-merged"},
    {"color": [70, 130, 180], "isthing": 0, "id": 187, "name": "sky-other-merged"},
    {"color": [134, 199, 156], "isthing": 0, "id": 188, "name": "cabinet-merged"},
    {"color": [209, 226, 140], "isthing": 0, "id": 189, "name": "table-merged"},
    {"color": [96, 36, 108], "isthing": 0, "id": 190, "name": "floor-other-merged"},
    {"color": [96, 96, 96], "isthing": 0, "id": 191, "name": "pavement-merged"},
    {"color": [64, 170, 64], "isthing": 0, "id": 192, "name": "mountain-merged"},
    {"color": [152, 251, 152], "isthing": 0, "id": 193, "name": "grass-merged"},
    {"color": [208, 229, 228], "isthing": 0, "id": 194, "name": "dirt-merged"},
    {"color": [206, 186, 171], "isthing": 0, "id": 195, "name": "paper-merged"},
    {"color": [152, 161, 64], "isthing": 0, "id": 196, "name": "food-other-merged"},
    {"color": [116, 112, 0], "isthing": 0, "id": 197, "name": "building-other-merged"},
    {"color": [0, 114, 143], "isthing": 0, "id": 198, "name": "rock-merged"},
    {"color": [102, 102, 156], "isthing": 0, "id": 199, "name": "wall-other-merged"},
    {"color": [250, 141, 255], "isthing": 0, "id": 200, "name": "rug-merged"},
]

ADE20K_150_CATEGORIES = [
    {"color": [120, 120, 120], "id": 0, "isthing": 0, "name": "wall"},
    {"color": [180, 120, 120], "id": 1, "isthing": 0, "name": "building"},
    {"color": [6, 230, 230], "id": 2, "isthing": 0, "name": "sky"},
    {"color": [80, 50, 50], "id": 3, "isthing": 0, "name": "floor"},
    {"color": [4, 200, 3], "id": 4, "isthing": 0, "name": "tree"},
    {"color": [120, 120, 80], "id": 5, "isthing": 0, "name": "ceiling"},
    {"color": [140, 140, 140], "id": 6, "isthing": 0, "name": "road, route"},
    {"color": [204, 5, 255], "id": 7, "isthing": 1, "name": "bed"},
    {"color": [230, 230, 230], "id": 8, "isthing": 1, "name": "window "},
    {"color": [4, 250, 7], "id": 9, "isthing": 0, "name": "grass"},
    {"color": [224, 5, 255], "id": 10, "isthing": 1, "name": "cabinet"},
    {"color": [235, 255, 7], "id": 11, "isthing": 0, "name": "sidewalk, pavement"},
    {"color": [150, 5, 61], "id": 12, "isthing": 1, "name": "person"},
    {"color": [120, 120, 70], "id": 13, "isthing": 0, "name": "earth, ground"},
    {"color": [8, 255, 51], "id": 14, "isthing": 1, "name": "door"},
    {"color": [255, 6, 82], "id": 15, "isthing": 1, "name": "table"},
    {"color": [143, 255, 140], "id": 16, "isthing": 0, "name": "mountain, mount"},
    {"color": [204, 255, 4], "id": 17, "isthing": 0, "name": "plant"},
    {"color": [255, 51, 7], "id": 18, "isthing": 1, "name": "curtain"},
    {"color": [204, 70, 3], "id": 19, "isthing": 1, "name": "chair"},
    {"color": [0, 102, 200], "id": 20, "isthing": 1, "name": "car"},
    {"color": [61, 230, 250], "id": 21, "isthing": 0, "name": "water"},
    {"color": [255, 6, 51], "id": 22, "isthing": 1, "name": "painting, picture"},
    {"color": [11, 102, 255], "id": 23, "isthing": 1, "name": "sofa"},
    {"color": [255, 7, 71], "id": 24, "isthing": 1, "name": "shelf"},
    {"color": [255, 9, 224], "id": 25, "isthing": 0, "name": "house"},
    {"color": [9, 7, 230], "id": 26, "isthing": 0, "name": "sea"},
    {"color": [220, 220, 220], "id": 27, "isthing": 1, "name": "mirror"},
    {"color": [255, 9, 92], "id": 28, "isthing": 0, "name": "rug"},
    {"color": [112, 9, 255], "id": 29, "isthing": 0, "name": "field"},
    {"color": [8, 255, 214], "id": 30, "isthing": 1, "name": "armchair"},
    {"color": [7, 255, 224], "id": 31, "isthing": 1, "name": "seat"},
    {"color": [255, 184, 6], "id": 32, "isthing": 1, "name": "fence"},
    {"color": [10, 255, 71], "id": 33, "isthing": 1, "name": "desk"},
    {"color": [255, 41, 10], "id": 34, "isthing": 0, "name": "rock, stone"},
    {"color": [7, 255, 255], "id": 35, "isthing": 1, "name": "wardrobe, closet, press"},
    {"color": [224, 255, 8], "id": 36, "isthing": 1, "name": "lamp"},
    {"color": [102, 8, 255], "id": 37, "isthing": 1, "name": "tub"},
    {"color": [255, 61, 6], "id": 38, "isthing": 1, "name": "rail"},
    {"color": [255, 194, 7], "id": 39, "isthing": 1, "name": "cushion"},
    {"color": [255, 122, 8], "id": 40, "isthing": 0, "name": "base, pedestal, stand"},
    {"color": [0, 255, 20], "id": 41, "isthing": 1, "name": "box"},
    {"color": [255, 8, 41], "id": 42, "isthing": 1, "name": "column, pillar"},
    {"color": [255, 5, 153], "id": 43, "isthing": 1, "name": "signboard, sign"},
    {
        "color": [6, 51, 255],
        "id": 44,
        "isthing": 1,
        "name": "chest of drawers, chest, bureau, dresser",
    },
    {"color": [235, 12, 255], "id": 45, "isthing": 1, "name": "counter"},
    {"color": [160, 150, 20], "id": 46, "isthing": 0, "name": "sand"},
    {"color": [0, 163, 255], "id": 47, "isthing": 1, "name": "sink"},
    {"color": [140, 140, 140], "id": 48, "isthing": 0, "name": "skyscraper"},
    {"color": [250, 10, 15], "id": 49, "isthing": 1, "name": "fireplace"},
    {"color": [20, 255, 0], "id": 50, "isthing": 1, "name": "refrigerator, icebox"},
    {"color": [31, 255, 0], "id": 51, "isthing": 0, "name": "grandstand, covered stand"},
    {"color": [255, 31, 0], "id": 52, "isthing": 0, "name": "path"},
    {"color": [255, 224, 0], "id": 53, "isthing": 1, "name": "stairs"},
    {"color": [153, 255, 0], "id": 54, "isthing": 0, "name": "runway"},
    {"color": [0, 0, 255], "id": 55, "isthing": 1, "name": "case, display case, showcase, vitrine"},
    {
        "color": [255, 71, 0],
        "id": 56,
        "isthing": 1,
        "name": "pool table, billiard table, snooker table",
    },
    {"color": [0, 235, 255], "id": 57, "isthing": 1, "name": "pillow"},
    {"color": [0, 173, 255], "id": 58, "isthing": 1, "name": "screen door, screen"},
    {"color": [31, 0, 255], "id": 59, "isthing": 0, "name": "stairway, staircase"},
    {"color": [11, 200, 200], "id": 60, "isthing": 0, "name": "river"},
    {"color": [255, 82, 0], "id": 61, "isthing": 0, "name": "bridge, span"},
    {"color": [0, 255, 245], "id": 62, "isthing": 1, "name": "bookcase"},
    {"color": [0, 61, 255], "id": 63, "isthing": 0, "name": "blind, screen"},
    {"color": [0, 255, 112], "id": 64, "isthing": 1, "name": "coffee table"},
    {
        "color": [0, 255, 133],
        "id": 65,
        "isthing": 1,
        "name": "toilet, can, commode, crapper, pot, potty, stool, throne",
    },
    {"color": [255, 0, 0], "id": 66, "isthing": 1, "name": "flower"},
    {"color": [255, 163, 0], "id": 67, "isthing": 1, "name": "book"},
    {"color": [255, 102, 0], "id": 68, "isthing": 0, "name": "hill"},
    {"color": [194, 255, 0], "id": 69, "isthing": 1, "name": "bench"},
    {"color": [0, 143, 255], "id": 70, "isthing": 1, "name": "countertop"},
    {"color": [51, 255, 0], "id": 71, "isthing": 1, "name": "stove"},
    {"color": [0, 82, 255], "id": 72, "isthing": 1, "name": "palm, palm tree"},
    {"color": [0, 255, 41], "id": 73, "isthing": 1, "name": "kitchen island"},
    {"color": [0, 255, 173], "id": 74, "isthing": 1, "name": "computer"},
    {"color": [10, 0, 255], "id": 75, "isthing": 1, "name": "swivel chair"},
    {"color": [173, 255, 0], "id": 76, "isthing": 1, "name": "boat"},
    {"color": [0, 255, 153], "id": 77, "isthing": 0, "name": "bar"},
    {"color": [255, 92, 0], "id": 78, "isthing": 1, "name": "arcade machine"},
    {"color": [255, 0, 255], "id": 79, "isthing": 0, "name": "hovel, hut, hutch, shack, shanty"},
    {"color": [255, 0, 245], "id": 80, "isthing": 1, "name": "bus"},
    {"color": [255, 0, 102], "id": 81, "isthing": 1, "name": "towel"},
    {"color": [255, 173, 0], "id": 82, "isthing": 1, "name": "light"},
    {"color": [255, 0, 20], "id": 83, "isthing": 1, "name": "truck"},
    {"color": [255, 184, 184], "id": 84, "isthing": 0, "name": "tower"},
    {"color": [0, 31, 255], "id": 85, "isthing": 1, "name": "chandelier"},
    {"color": [0, 255, 61], "id": 86, "isthing": 1, "name": "awning, sunshade, sunblind"},
    {"color": [0, 71, 255], "id": 87, "isthing": 1, "name": "street lamp"},
    {"color": [255, 0, 204], "id": 88, "isthing": 1, "name": "booth"},
    {"color": [0, 255, 194], "id": 89, "isthing": 1, "name": "tv"},
    {"color": [0, 255, 82], "id": 90, "isthing": 1, "name": "plane"},
    {"color": [0, 10, 255], "id": 91, "isthing": 0, "name": "dirt track"},
    {"color": [0, 112, 255], "id": 92, "isthing": 1, "name": "clothes"},
    {"color": [51, 0, 255], "id": 93, "isthing": 1, "name": "pole"},
    {"color": [0, 194, 255], "id": 94, "isthing": 0, "name": "land, ground, soil"},
    {
        "color": [0, 122, 255],
        "id": 95,
        "isthing": 1,
        "name": "bannister, banister, balustrade, balusters, handrail",
    },
    {
        "color": [0, 255, 163],
        "id": 96,
        "isthing": 0,
        "name": "escalator, moving staircase, moving stairway",
    },
    {
        "color": [255, 153, 0],
        "id": 97,
        "isthing": 1,
        "name": "ottoman, pouf, pouffe, puff, hassock",
    },
    {"color": [0, 255, 10], "id": 98, "isthing": 1, "name": "bottle"},
    {"color": [255, 112, 0], "id": 99, "isthing": 0, "name": "buffet, counter, sideboard"},
    {
        "color": [143, 255, 0],
        "id": 100,
        "isthing": 0,
        "name": "poster, posting, placard, notice, bill, card",
    },
    {"color": [82, 0, 255], "id": 101, "isthing": 0, "name": "stage"},
    {"color": [163, 255, 0], "id": 102, "isthing": 1, "name": "van"},
    {"color": [255, 235, 0], "id": 103, "isthing": 1, "name": "ship"},
    {"color": [8, 184, 170], "id": 104, "isthing": 1, "name": "fountain"},
    {
        "color": [133, 0, 255],
        "id": 105,
        "isthing": 0,
        "name": "conveyer belt, conveyor belt, conveyer, conveyor, transporter",
    },
    {"color": [0, 255, 92], "id": 106, "isthing": 0, "name": "canopy"},
    {
        "color": [184, 0, 255],
        "id": 107,
        "isthing": 1,
        "name": "washer, automatic washer, washing machine",
    },
    {"color": [255, 0, 31], "id": 108, "isthing": 1, "name": "plaything, toy"},
    {"color": [0, 184, 255], "id": 109, "isthing": 0, "name": "pool"},
    {"color": [0, 214, 255], "id": 110, "isthing": 1, "name": "stool"},
    {"color": [255, 0, 112], "id": 111, "isthing": 1, "name": "barrel, cask"},
    {"color": [92, 255, 0], "id": 112, "isthing": 1, "name": "basket, handbasket"},
    {"color": [0, 224, 255], "id": 113, "isthing": 0, "name": "falls"},
    {"color": [112, 224, 255], "id": 114, "isthing": 0, "name": "tent"},
    {"color": [70, 184, 160], "id": 115, "isthing": 1, "name": "bag"},
    {"color": [163, 0, 255], "id": 116, "isthing": 1, "name": "minibike, motorbike"},
    {"color": [153, 0, 255], "id": 117, "isthing": 0, "name": "cradle"},
    {"color": [71, 255, 0], "id": 118, "isthing": 1, "name": "oven"},
    {"color": [255, 0, 163], "id": 119, "isthing": 1, "name": "ball"},
    {"color": [255, 204, 0], "id": 120, "isthing": 1, "name": "food, solid food"},
    {"color": [255, 0, 143], "id": 121, "isthing": 1, "name": "step, stair"},
    {"color": [0, 255, 235], "id": 122, "isthing": 0, "name": "tank, storage tank"},
    {"color": [133, 255, 0], "id": 123, "isthing": 1, "name": "trade name"},
    {"color": [255, 0, 235], "id": 124, "isthing": 1, "name": "microwave"},
    {"color": [245, 0, 255], "id": 125, "isthing": 1, "name": "pot"},
    {"color": [255, 0, 122], "id": 126, "isthing": 1, "name": "animal"},
    {"color": [255, 245, 0], "id": 127, "isthing": 1, "name": "bicycle"},
    {"color": [10, 190, 212], "id": 128, "isthing": 0, "name": "lake"},
    {"color": [214, 255, 0], "id": 129, "isthing": 1, "name": "dishwasher"},
    {"color": [0, 204, 255], "id": 130, "isthing": 1, "name": "screen"},
    {"color": [20, 0, 255], "id": 131, "isthing": 0, "name": "blanket, cover"},
    {"color": [255, 255, 0], "id": 132, "isthing": 1, "name": "sculpture"},
    {"color": [0, 153, 255], "id": 133, "isthing": 1, "name": "hood, exhaust hood"},
    {"color": [0, 41, 255], "id": 134, "isthing": 1, "name": "sconce"},
    {"color": [0, 255, 204], "id": 135, "isthing": 1, "name": "vase"},
    {"color": [41, 0, 255], "id": 136, "isthing": 1, "name": "traffic light"},
    {"color": [41, 255, 0], "id": 137, "isthing": 1, "name": "tray"},
    {"color": [173, 0, 255], "id": 138, "isthing": 1, "name": "trash can"},
    {"color": [0, 245, 255], "id": 139, "isthing": 1, "name": "fan"},
    {"color": [71, 0, 255], "id": 140, "isthing": 0, "name": "pier"},
    {"color": [122, 0, 255], "id": 141, "isthing": 0, "name": "crt screen"},
    {"color": [0, 255, 184], "id": 142, "isthing": 1, "name": "plate"},
    {"color": [0, 92, 255], "id": 143, "isthing": 1, "name": "monitor"},
    {"color": [184, 255, 0], "id": 144, "isthing": 1, "name": "bulletin board"},
    {"color": [0, 133, 255], "id": 145, "isthing": 0, "name": "shower"},
    {"color": [255, 214, 0], "id": 146, "isthing": 1, "name": "radiator"},
    {"color": [25, 194, 194], "id": 147, "isthing": 1, "name": "glass, drinking glass"},
    {"color": [102, 255, 0], "id": 148, "isthing": 1, "name": "clock"},
    {"color": [92, 0, 255], "id": 149, "isthing": 1, "name": "flag"},
]

CITYSCAPES_CATEGORIES = [
    {"color": (128, 64, 128), "isthing": 0, "id": 7, "trainId": 0, "name": "road"},
    {"color": (244, 35, 232), "isthing": 0, "id": 8, "trainId": 1, "name": "sidewalk"},
    {"color": (70, 70, 70), "isthing": 0, "id": 11, "trainId": 2, "name": "building"},
    {"color": (102, 102, 156), "isthing": 0, "id": 12, "trainId": 3, "name": "wall"},
    {"color": (190, 153, 153), "isthing": 0, "id": 13, "trainId": 4, "name": "fence"},
    {"color": (153, 153, 153), "isthing": 0, "id": 17, "trainId": 5, "name": "pole"},
    {"color": (250, 170, 30), "isthing": 0, "id": 19, "trainId": 6, "name": "traffic light"},
    {"color": (220, 220, 0), "isthing": 0, "id": 20, "trainId": 7, "name": "traffic sign"},
    {"color": (107, 142, 35), "isthing": 0, "id": 21, "trainId": 8, "name": "vegetation"},
    {"color": (152, 251, 152), "isthing": 0, "id": 22, "trainId": 9, "name": "terrain"},
    {"color": (70, 130, 180), "isthing": 0, "id": 23, "trainId": 10, "name": "sky"},
    {"color": (220, 20, 60), "isthing": 1, "id": 24, "trainId": 11, "name": "person"},
    {"color": (255, 0, 0), "isthing": 1, "id": 25, "trainId": 12, "name": "rider"},
    {"color": (0, 0, 142), "isthing": 1, "id": 26, "trainId": 13, "name": "car"},
    {"color": (0, 0, 70), "isthing": 1, "id": 27, "trainId": 14, "name": "truck"},
    {"color": (0, 60, 100), "isthing": 1, "id": 28, "trainId": 15, "name": "bus"},
    {"color": (0, 80, 100), "isthing": 1, "id": 31, "trainId": 16, "name": "train"},
    {"color": (0, 0, 230), "isthing": 1, "id": 32, "trainId": 17, "name": "motorcycle"},
    {"color": (119, 11, 32), "isthing": 1, "id": 33, "trainId": 18, "name": "bicycle"},
]

ADE20K_847_CATEGORIES = [
    {"name": "wall", "id": 2978, "trainId": 0},
    {"name": "building, edifice", "id": 312, "trainId": 1},
    {"name": "sky", "id": 2420, "trainId": 2},
    {"name": "tree", "id": 2855, "trainId": 3},
    {"name": "road, route", "id": 2131, "trainId": 4},
    {"name": "floor, flooring", "id": 976, "trainId": 5},
    {"name": "ceiling", "id": 447, "trainId": 6},
    {"name": "bed", "id": 165, "trainId": 7},
    {"name": "sidewalk, pavement", "id": 2377, "trainId": 8},
    {"name": "earth, ground", "id": 838, "trainId": 9},
    {"name": "cabinet", "id": 350, "trainId": 10},
    {"name": "person, individual, someone, somebody, mortal, soul", "id": 1831, "trainId": 11},
    {"name": "grass", "id": 1125, "trainId": 12},
    {"name": "windowpane, window", "id": 3055, "trainId": 13},
    {"name": "car, auto, automobile, machine, motorcar", "id": 401, "trainId": 14},
    {"name": "mountain, mount", "id": 1610, "trainId": 15},
    {"name": "plant, flora, plant life", "id": 1910, "trainId": 16},
    {"name": "table", "id": 2684, "trainId": 17},
    {"name": "chair", "id": 471, "trainId": 18},
    {"name": "curtain, drape, drapery, mantle, pall", "id": 687, "trainId": 19},
    {"name": "door", "id": 774, "trainId": 20},
    {"name": "sofa, couch, lounge", "id": 2473, "trainId": 21},
    {"name": "sea", "id": 2264, "trainId": 22},
    {"name": "painting, picture", "id": 1735, "trainId": 23},
    {"name": "water", "id": 2994, "trainId": 24},
    {"name": "mirror", "id": 1564, "trainId": 25},
    {"name": "house", "id": 1276, "trainId": 26},
    {"name": "rug, carpet, carpeting", "id": 2178, "trainId": 27},
    {"name": "shelf", "id": 2329, "trainId": 28},
    {"name": "armchair", "id": 57, "trainId": 29},
    {"name": "fence, fencing", "id": 907, "trainId": 30},
    {"name": "field", "id": 913, "trainId": 31},
    {"name": "lamp", "id": 1395, "trainId": 32},
    {"name": "rock, stone", "id": 2138, "trainId": 33},
    {"name": "seat", "id": 2272, "trainId": 34},
    {"name": "river", "id": 2128, "trainId": 35},
    {"name": "desk", "id": 724, "trainId": 36},
    {"name": "bathtub, bathing tub, bath, tub", "id": 155, "trainId": 37},
    {"name": "railing, rail", "id": 2053, "trainId": 38},
    {"name": "signboard, sign", "id": 2380, "trainId": 39},
    {"name": "cushion", "id": 689, "trainId": 40},
    {"name": "path", "id": 1788, "trainId": 41},
    {"name": "work surface", "id": 3087, "trainId": 42},
    {"name": "stairs, steps", "id": 2530, "trainId": 43},
    {"name": "column, pillar", "id": 581, "trainId": 44},
    {"name": "sink", "id": 2388, "trainId": 45},
    {"name": "wardrobe, closet, press", "id": 2985, "trainId": 46},
    {"name": "snow", "id": 2454, "trainId": 47},
    {"name": "refrigerator, icebox", "id": 2096, "trainId": 48},
    {"name": "base, pedestal, stand", "id": 137, "trainId": 49},
    {"name": "bridge, span", "id": 294, "trainId": 50},
    {"name": "blind, screen", "id": 212, "trainId": 51},
    {"name": "runway", "id": 2185, "trainId": 52},
    {"name": "cliff, drop, drop-off", "id": 524, "trainId": 53},
    {"name": "sand", "id": 2212, "trainId": 54},
    {"name": "fireplace, hearth, open fireplace", "id": 943, "trainId": 55},
    {"name": "pillow", "id": 1869, "trainId": 56},
    {"name": "screen door, screen", "id": 2251, "trainId": 57},
    {"name": "toilet, can, commode, crapper, pot, potty, stool, throne", "id": 2793, "trainId": 58},
    {"name": "skyscraper", "id": 2423, "trainId": 59},
    {"name": "grandstand, covered stand", "id": 1121, "trainId": 60},
    {"name": "box", "id": 266, "trainId": 61},
    {"name": "pool table, billiard table, snooker table", "id": 1948, "trainId": 62},
    {"name": "palm, palm tree", "id": 1744, "trainId": 63},
    {"name": "double door", "id": 783, "trainId": 64},
    {"name": "coffee table, cocktail table", "id": 571, "trainId": 65},
    {"name": "counter", "id": 627, "trainId": 66},
    {"name": "countertop", "id": 629, "trainId": 67},
    {"name": "chest of drawers, chest, bureau, dresser", "id": 491, "trainId": 68},
    {"name": "kitchen island", "id": 1374, "trainId": 69},
    {"name": "boat", "id": 223, "trainId": 70},
    {"name": "waterfall, falls", "id": 3016, "trainId": 71},
    {
        "name": "stove, kitchen stove, range, kitchen range, cooking stove",
        "id": 2598,
        "trainId": 72,
    },
    {"name": "flower", "id": 978, "trainId": 73},
    {"name": "bookcase", "id": 239, "trainId": 74},
    {"name": "controls", "id": 608, "trainId": 75},
    {"name": "book", "id": 236, "trainId": 76},
    {"name": "stairway, staircase", "id": 2531, "trainId": 77},
    {"name": "streetlight, street lamp", "id": 2616, "trainId": 78},
    {
        "name": "computer, computing machine, computing device, data processor, electronic computer, information processing system",
        "id": 591,
        "trainId": 79,
    },
    {
        "name": "bus, autobus, coach, charabanc, double-decker, jitney, motorbus, motorcoach, omnibus, passenger vehicle",
        "id": 327,
        "trainId": 80,
    },
    {"name": "swivel chair", "id": 2679, "trainId": 81},
    {"name": "light, light source", "id": 1451, "trainId": 82},
    {"name": "bench", "id": 181, "trainId": 83},
    {"name": "case, display case, showcase, vitrine", "id": 420, "trainId": 84},
    {"name": "towel", "id": 2821, "trainId": 85},
    {"name": "fountain", "id": 1023, "trainId": 86},
    {"name": "embankment", "id": 855, "trainId": 87},
    {
        "name": "television receiver, television, television set, tv, tv set, idiot box, boob tube, telly, goggle box",
        "id": 2733,
        "trainId": 88,
    },
    {"name": "van", "id": 2928, "trainId": 89},
    {"name": "hill", "id": 1240, "trainId": 90},
    {"name": "awning, sunshade, sunblind", "id": 77, "trainId": 91},
    {"name": "poster, posting, placard, notice, bill, card", "id": 1969, "trainId": 92},
    {"name": "truck, motortruck", "id": 2880, "trainId": 93},
    {"name": "airplane, aeroplane, plane", "id": 14, "trainId": 94},
    {"name": "pole", "id": 1936, "trainId": 95},
    {"name": "tower", "id": 2828, "trainId": 96},
    {"name": "court", "id": 631, "trainId": 97},
    {"name": "ball", "id": 103, "trainId": 98},
    {
        "name": "aircraft carrier, carrier, flattop, attack aircraft carrier",
        "id": 3144,
        "trainId": 99,
    },
    {"name": "buffet, counter, sideboard", "id": 308, "trainId": 100},
    {"name": "hovel, hut, hutch, shack, shanty", "id": 1282, "trainId": 101},
    {"name": "apparel, wearing apparel, dress, clothes", "id": 38, "trainId": 102},
    {"name": "minibike, motorbike", "id": 1563, "trainId": 103},
    {"name": "animal, animate being, beast, brute, creature, fauna", "id": 29, "trainId": 104},
    {"name": "chandelier, pendant, pendent", "id": 480, "trainId": 105},
    {"name": "step, stair", "id": 2569, "trainId": 106},
    {"name": "booth, cubicle, stall, kiosk", "id": 247, "trainId": 107},
    {"name": "bicycle, bike, wheel, cycle", "id": 187, "trainId": 108},
    {"name": "doorframe, doorcase", "id": 778, "trainId": 109},
    {"name": "sconce", "id": 2243, "trainId": 110},
    {"name": "pond", "id": 1941, "trainId": 111},
    {"name": "trade name, brand name, brand, marque", "id": 2833, "trainId": 112},
    {"name": "bannister, banister, balustrade, balusters, handrail", "id": 120, "trainId": 113},
    {"name": "bag", "id": 95, "trainId": 114},
    {"name": "traffic light, traffic signal, stoplight", "id": 2836, "trainId": 115},
    {"name": "gazebo", "id": 1087, "trainId": 116},
    {"name": "escalator, moving staircase, moving stairway", "id": 868, "trainId": 117},
    {"name": "land, ground, soil", "id": 1401, "trainId": 118},
    {"name": "board, plank", "id": 220, "trainId": 119},
    {"name": "arcade machine", "id": 47, "trainId": 120},
    {"name": "eiderdown, duvet, continental quilt", "id": 843, "trainId": 121},
    {"name": "bar", "id": 123, "trainId": 122},
    {"name": "stall, stand, sales booth", "id": 2537, "trainId": 123},
    {"name": "playground", "id": 1927, "trainId": 124},
    {"name": "ship", "id": 2337, "trainId": 125},
    {"name": "ottoman, pouf, pouffe, puff, hassock", "id": 1702, "trainId": 126},
    {
        "name": "ashcan, trash can, garbage can, wastebin, ash bin, ash-bin, ashbin, dustbin, trash barrel, trash bin",
        "id": 64,
        "trainId": 127,
    },
    {"name": "bottle", "id": 249, "trainId": 128},
    {"name": "cradle", "id": 642, "trainId": 129},
    {"name": "pot, flowerpot", "id": 1981, "trainId": 130},
    {
        "name": "conveyer belt, conveyor belt, conveyer, conveyor, transporter",
        "id": 609,
        "trainId": 131,
    },
    {"name": "train, railroad train", "id": 2840, "trainId": 132},
    {"name": "stool", "id": 2586, "trainId": 133},
    {"name": "lake", "id": 1393, "trainId": 134},
    {"name": "tank, storage tank", "id": 2704, "trainId": 135},
    {"name": "ice, water ice", "id": 1304, "trainId": 136},
    {"name": "basket, handbasket", "id": 146, "trainId": 137},
    {"name": "manhole", "id": 1494, "trainId": 138},
    {"name": "tent, collapsible shelter", "id": 2739, "trainId": 139},
    {"name": "canopy", "id": 389, "trainId": 140},
    {"name": "microwave, microwave oven", "id": 1551, "trainId": 141},
    {"name": "barrel, cask", "id": 131, "trainId": 142},
    {"name": "dirt track", "id": 738, "trainId": 143},
    {"name": "beam", "id": 161, "trainId": 144},
    {"name": "dishwasher, dish washer, dishwashing machine", "id": 747, "trainId": 145},
    {"name": "plate", "id": 1919, "trainId": 146},
    {"name": "screen, crt screen", "id": 3109, "trainId": 147},
    {"name": "ruins", "id": 2179, "trainId": 148},
    {"name": "washer, automatic washer, washing machine", "id": 2989, "trainId": 149},
    {"name": "blanket, cover", "id": 206, "trainId": 150},
    {"name": "plaything, toy", "id": 1930, "trainId": 151},
    {"name": "food, solid food", "id": 1002, "trainId": 152},
    {"name": "screen, silver screen, projection screen", "id": 2254, "trainId": 153},
    {"name": "oven", "id": 1708, "trainId": 154},
    {"name": "stage", "id": 2526, "trainId": 155},
    {"name": "beacon, lighthouse, beacon light, pharos", "id": 160, "trainId": 156},
    {"name": "umbrella", "id": 2901, "trainId": 157},
    {"name": "sculpture", "id": 2262, "trainId": 158},
    {"name": "aqueduct", "id": 44, "trainId": 159},
    {"name": "container", "id": 597, "trainId": 160},
    {"name": "scaffolding, staging", "id": 2235, "trainId": 161},
    {"name": "hood, exhaust hood", "id": 1260, "trainId": 162},
    {"name": "curb, curbing, kerb", "id": 682, "trainId": 163},
    {"name": "roller coaster", "id": 2151, "trainId": 164},
    {"name": "horse, equus caballus", "id": 3107, "trainId": 165},
    {"name": "catwalk", "id": 432, "trainId": 166},
    {"name": "glass, drinking glass", "id": 1098, "trainId": 167},
    {"name": "vase", "id": 2932, "trainId": 168},
    {"name": "central reservation", "id": 461, "trainId": 169},
    {"name": "carousel", "id": 410, "trainId": 170},
    {"name": "radiator", "id": 2046, "trainId": 171},
    {"name": "closet", "id": 533, "trainId": 172},
    {"name": "machine", "id": 1481, "trainId": 173},
    {"name": "pier, wharf, wharfage, dock", "id": 1858, "trainId": 174},
    {"name": "fan", "id": 894, "trainId": 175},
    {"name": "inflatable bounce game", "id": 1322, "trainId": 176},
    {"name": "pitch", "id": 1891, "trainId": 177},
    {"name": "paper", "id": 1756, "trainId": 178},
    {"name": "arcade, colonnade", "id": 49, "trainId": 179},
    {"name": "hot tub", "id": 1272, "trainId": 180},
    {"name": "helicopter", "id": 1229, "trainId": 181},
    {"name": "tray", "id": 2850, "trainId": 182},
    {"name": "partition, divider", "id": 1784, "trainId": 183},
    {"name": "vineyard", "id": 2962, "trainId": 184},
    {"name": "bowl", "id": 259, "trainId": 185},
    {"name": "bullring", "id": 319, "trainId": 186},
    {"name": "flag", "id": 954, "trainId": 187},
    {"name": "pot", "id": 1974, "trainId": 188},
    {"name": "footbridge, overcrossing, pedestrian bridge", "id": 1013, "trainId": 189},
    {"name": "shower", "id": 2356, "trainId": 190},
    {"name": "bag, traveling bag, travelling bag, grip, suitcase", "id": 97, "trainId": 191},
    {"name": "bulletin board, notice board", "id": 318, "trainId": 192},
    {"name": "confessional booth", "id": 592, "trainId": 193},
    {"name": "trunk, tree trunk, bole", "id": 2885, "trainId": 194},
    {"name": "forest", "id": 1017, "trainId": 195},
    {"name": "elevator door", "id": 851, "trainId": 196},
    {"name": "laptop, laptop computer", "id": 1407, "trainId": 197},
    {"name": "instrument panel", "id": 1332, "trainId": 198},
    {"name": "bucket, pail", "id": 303, "trainId": 199},
    {"name": "tapestry, tapis", "id": 2714, "trainId": 200},
    {"name": "platform", "id": 1924, "trainId": 201},
    {"name": "jacket", "id": 1346, "trainId": 202},
    {"name": "gate", "id": 1081, "trainId": 203},
    {"name": "monitor, monitoring device", "id": 1583, "trainId": 204},
    {
        "name": "telephone booth, phone booth, call box, telephone box, telephone kiosk",
        "id": 2727,
        "trainId": 205,
    },
    {"name": "spotlight, spot", "id": 2509, "trainId": 206},
    {"name": "ring", "id": 2123, "trainId": 207},
    {"name": "control panel", "id": 602, "trainId": 208},
    {"name": "blackboard, chalkboard", "id": 202, "trainId": 209},
    {"name": "air conditioner, air conditioning", "id": 10, "trainId": 210},
    {"name": "chest", "id": 490, "trainId": 211},
    {"name": "clock", "id": 530, "trainId": 212},
    {"name": "sand dune", "id": 2213, "trainId": 213},
    {"name": "pipe, pipage, piping", "id": 1884, "trainId": 214},
    {"name": "vault", "id": 2934, "trainId": 215},
    {"name": "table football", "id": 2687, "trainId": 216},
    {"name": "cannon", "id": 387, "trainId": 217},
    {"name": "swimming pool, swimming bath, natatorium", "id": 2668, "trainId": 218},
    {"name": "fluorescent, fluorescent fixture", "id": 982, "trainId": 219},
    {"name": "statue", "id": 2547, "trainId": 220},
    {
        "name": "loudspeaker, speaker, speaker unit, loudspeaker system, speaker system",
        "id": 1474,
        "trainId": 221,
    },
    {"name": "exhibitor", "id": 877, "trainId": 222},
    {"name": "ladder", "id": 1391, "trainId": 223},
    {"name": "carport", "id": 414, "trainId": 224},
    {"name": "dam", "id": 698, "trainId": 225},
    {"name": "pulpit", "id": 2019, "trainId": 226},
    {"name": "skylight, fanlight", "id": 2422, "trainId": 227},
    {"name": "water tower", "id": 3010, "trainId": 228},
    {"name": "grill, grille, grillwork", "id": 1139, "trainId": 229},
    {"name": "display board", "id": 753, "trainId": 230},
    {"name": "pane, pane of glass, window glass", "id": 1747, "trainId": 231},
    {"name": "rubbish, trash, scrap", "id": 2175, "trainId": 232},
    {"name": "ice rink", "id": 1301, "trainId": 233},
    {"name": "fruit", "id": 1033, "trainId": 234},
    {"name": "patio", "id": 1789, "trainId": 235},
    {"name": "vending machine", "id": 2939, "trainId": 236},
    {"name": "telephone, phone, telephone set", "id": 2730, "trainId": 237},
    {"name": "net", "id": 1652, "trainId": 238},
    {
        "name": "backpack, back pack, knapsack, packsack, rucksack, haversack",
        "id": 90,
        "trainId": 239,
    },
    {"name": "jar", "id": 1349, "trainId": 240},
    {"name": "track", "id": 2830, "trainId": 241},
    {"name": "magazine", "id": 1485, "trainId": 242},
    {"name": "shutter", "id": 2370, "trainId": 243},
    {"name": "roof", "id": 2155, "trainId": 244},
    {"name": "banner, streamer", "id": 118, "trainId": 245},
    {"name": "landfill", "id": 1402, "trainId": 246},
    {"name": "post", "id": 1957, "trainId": 247},
    {"name": "altarpiece, reredos", "id": 3130, "trainId": 248},
    {"name": "hat, chapeau, lid", "id": 1197, "trainId": 249},
    {"name": "arch, archway", "id": 52, "trainId": 250},
    {"name": "table game", "id": 2688, "trainId": 251},
    {"name": "bag, handbag, pocketbook, purse", "id": 96, "trainId": 252},
    {"name": "document, written document, papers", "id": 762, "trainId": 253},
    {"name": "dome", "id": 772, "trainId": 254},
    {"name": "pier", "id": 1857, "trainId": 255},
    {"name": "shanties", "id": 2315, "trainId": 256},
    {"name": "forecourt", "id": 1016, "trainId": 257},
    {"name": "crane", "id": 643, "trainId": 258},
    {"name": "dog, domestic dog, canis familiaris", "id": 3105, "trainId": 259},
    {"name": "piano, pianoforte, forte-piano", "id": 1849, "trainId": 260},
    {"name": "drawing", "id": 791, "trainId": 261},
    {"name": "cabin", "id": 349, "trainId": 262},
    {
        "name": "ad, advertisement, advertizement, advertising, advertizing, advert",
        "id": 6,
        "trainId": 263,
    },
    {"name": "amphitheater, amphitheatre, coliseum", "id": 3114, "trainId": 264},
    {"name": "monument", "id": 1587, "trainId": 265},
    {"name": "henhouse", "id": 1233, "trainId": 266},
    {"name": "cockpit", "id": 559, "trainId": 267},
    {"name": "heater, warmer", "id": 1223, "trainId": 268},
    {"name": "windmill, aerogenerator, wind generator", "id": 3049, "trainId": 269},
    {"name": "pool", "id": 1943, "trainId": 270},
    {"name": "elevator, lift", "id": 853, "trainId": 271},
    {"name": "decoration, ornament, ornamentation", "id": 709, "trainId": 272},
    {"name": "labyrinth", "id": 1390, "trainId": 273},
    {"name": "text, textual matter", "id": 2748, "trainId": 274},
    {"name": "printer", "id": 2007, "trainId": 275},
    {"name": "mezzanine, first balcony", "id": 1546, "trainId": 276},
    {"name": "mattress", "id": 1513, "trainId": 277},
    {"name": "straw", "id": 2600, "trainId": 278},
    {"name": "stalls", "id": 2538, "trainId": 279},
    {"name": "patio, terrace", "id": 1790, "trainId": 280},
    {"name": "billboard, hoarding", "id": 194, "trainId": 281},
    {"name": "bus stop", "id": 326, "trainId": 282},
    {"name": "trouser, pant", "id": 2877, "trainId": 283},
    {"name": "console table, console", "id": 594, "trainId": 284},
    {"name": "rack", "id": 2036, "trainId": 285},
    {"name": "notebook", "id": 1662, "trainId": 286},
    {"name": "shrine", "id": 2366, "trainId": 287},
    {"name": "pantry", "id": 1754, "trainId": 288},
    {"name": "cart", "id": 418, "trainId": 289},
    {"name": "steam shovel", "id": 2553, "trainId": 290},
    {"name": "porch", "id": 1951, "trainId": 291},
    {"name": "postbox, mailbox, letter box", "id": 1963, "trainId": 292},
    {"name": "figurine, statuette", "id": 918, "trainId": 293},
    {"name": "recycling bin", "id": 2086, "trainId": 294},
    {"name": "folding screen", "id": 997, "trainId": 295},
    {"name": "telescope", "id": 2731, "trainId": 296},
    {"name": "deck chair, beach chair", "id": 704, "trainId": 297},
    {"name": "kennel", "id": 1365, "trainId": 298},
    {"name": "coffee maker", "id": 569, "trainId": 299},
    {"name": "altar, communion table, lord's table", "id": 3108, "trainId": 300},
    {"name": "fish", "id": 948, "trainId": 301},
    {"name": "easel", "id": 839, "trainId": 302},
    {"name": "artificial golf green", "id": 63, "trainId": 303},
    {"name": "iceberg", "id": 1305, "trainId": 304},
    {"name": "candlestick, candle holder", "id": 378, "trainId": 305},
    {"name": "shower stall, shower bath", "id": 2362, "trainId": 306},
    {"name": "television stand", "id": 2734, "trainId": 307},
    {
        "name": "wall socket, wall plug, electric outlet, electrical outlet, outlet, electric receptacle",
        "id": 2982,
        "trainId": 308,
    },
    {"name": "skeleton", "id": 2398, "trainId": 309},
    {"name": "grand piano, grand", "id": 1119, "trainId": 310},
    {"name": "candy, confect", "id": 382, "trainId": 311},
    {"name": "grille door", "id": 1141, "trainId": 312},
    {"name": "pedestal, plinth, footstall", "id": 1805, "trainId": 313},
    {"name": "jersey, t-shirt, tee shirt", "id": 3102, "trainId": 314},
    {"name": "shoe", "id": 2341, "trainId": 315},
    {"name": "gravestone, headstone, tombstone", "id": 1131, "trainId": 316},
    {"name": "shanty", "id": 2316, "trainId": 317},
    {"name": "structure", "id": 2626, "trainId": 318},
    {"name": "rocking chair, rocker", "id": 3104, "trainId": 319},
    {"name": "bird", "id": 198, "trainId": 320},
    {"name": "place mat", "id": 1896, "trainId": 321},
    {"name": "tomb", "id": 2800, "trainId": 322},
    {"name": "big top", "id": 190, "trainId": 323},
    {"name": "gas pump, gasoline pump, petrol pump, island dispenser", "id": 3131, "trainId": 324},
    {"name": "lockers", "id": 1463, "trainId": 325},
    {"name": "cage", "id": 357, "trainId": 326},
    {"name": "finger", "id": 929, "trainId": 327},
    {"name": "bleachers", "id": 209, "trainId": 328},
    {"name": "ferris wheel", "id": 912, "trainId": 329},
    {"name": "hairdresser chair", "id": 1164, "trainId": 330},
    {"name": "mat", "id": 1509, "trainId": 331},
    {"name": "stands", "id": 2539, "trainId": 332},
    {"name": "aquarium, fish tank, marine museum", "id": 3116, "trainId": 333},
    {"name": "streetcar, tram, tramcar, trolley, trolley car", "id": 2615, "trainId": 334},
    {"name": "napkin, table napkin, serviette", "id": 1644, "trainId": 335},
    {"name": "dummy", "id": 818, "trainId": 336},
    {"name": "booklet, brochure, folder, leaflet, pamphlet", "id": 242, "trainId": 337},
    {"name": "sand trap", "id": 2217, "trainId": 338},
    {"name": "shop, store", "id": 2347, "trainId": 339},
    {"name": "table cloth", "id": 2686, "trainId": 340},
    {"name": "service station", "id": 2300, "trainId": 341},
    {"name": "coffin", "id": 572, "trainId": 342},
    {"name": "drawer", "id": 789, "trainId": 343},
    {"name": "cages", "id": 358, "trainId": 344},
    {"name": "slot machine, coin machine", "id": 2443, "trainId": 345},
    {"name": "balcony", "id": 101, "trainId": 346},
    {"name": "volleyball court", "id": 2969, "trainId": 347},
    {"name": "table tennis", "id": 2692, "trainId": 348},
    {"name": "control table", "id": 606, "trainId": 349},
    {"name": "shirt", "id": 2339, "trainId": 350},
    {"name": "merchandise, ware, product", "id": 1533, "trainId": 351},
    {"name": "railway", "id": 2060, "trainId": 352},
    {"name": "parterre", "id": 1782, "trainId": 353},
    {"name": "chimney", "id": 495, "trainId": 354},
    {"name": "can, tin, tin can", "id": 371, "trainId": 355},
    {"name": "tanks", "id": 2707, "trainId": 356},
    {"name": "fabric, cloth, material, textile", "id": 889, "trainId": 357},
    {"name": "alga, algae", "id": 3156, "trainId": 358},
    {"name": "system", "id": 2683, "trainId": 359},
    {"name": "map", "id": 1499, "trainId": 360},
    {"name": "greenhouse", "id": 1135, "trainId": 361},
    {"name": "mug", "id": 1619, "trainId": 362},
    {"name": "barbecue", "id": 125, "trainId": 363},
    {"name": "trailer", "id": 2838, "trainId": 364},
    {"name": "toilet tissue, toilet paper, bathroom tissue", "id": 2792, "trainId": 365},
    {"name": "organ", "id": 1695, "trainId": 366},
    {"name": "dishrag, dishcloth", "id": 746, "trainId": 367},
    {"name": "island", "id": 1343, "trainId": 368},
    {"name": "keyboard", "id": 1370, "trainId": 369},
    {"name": "trench", "id": 2858, "trainId": 370},
    {"name": "basket, basketball hoop, hoop", "id": 145, "trainId": 371},
    {"name": "steering wheel, wheel", "id": 2565, "trainId": 372},
    {"name": "pitcher, ewer", "id": 1892, "trainId": 373},
    {"name": "goal", "id": 1103, "trainId": 374},
    {"name": "bread, breadstuff, staff of life", "id": 286, "trainId": 375},
    {"name": "beds", "id": 170, "trainId": 376},
    {"name": "wood", "id": 3073, "trainId": 377},
    {"name": "file cabinet", "id": 922, "trainId": 378},
    {"name": "newspaper, paper", "id": 1655, "trainId": 379},
    {"name": "motorboat", "id": 1602, "trainId": 380},
    {"name": "rope", "id": 2160, "trainId": 381},
    {"name": "guitar", "id": 1151, "trainId": 382},
    {"name": "rubble", "id": 2176, "trainId": 383},
    {"name": "scarf", "id": 2239, "trainId": 384},
    {"name": "barrels", "id": 132, "trainId": 385},
    {"name": "cap", "id": 394, "trainId": 386},
    {"name": "leaves", "id": 1424, "trainId": 387},
    {"name": "control tower", "id": 607, "trainId": 388},
    {"name": "dashboard", "id": 700, "trainId": 389},
    {"name": "bandstand", "id": 116, "trainId": 390},
    {"name": "lectern", "id": 1425, "trainId": 391},
    {"name": "switch, electric switch, electrical switch", "id": 2676, "trainId": 392},
    {"name": "baseboard, mopboard, skirting board", "id": 141, "trainId": 393},
    {"name": "shower room", "id": 2360, "trainId": 394},
    {"name": "smoke", "id": 2449, "trainId": 395},
    {"name": "faucet, spigot", "id": 897, "trainId": 396},
    {"name": "bulldozer", "id": 317, "trainId": 397},
    {"name": "saucepan", "id": 2228, "trainId": 398},
    {"name": "shops", "id": 2351, "trainId": 399},
    {"name": "meter", "id": 1543, "trainId": 400},
    {"name": "crevasse", "id": 656, "trainId": 401},
    {"name": "gear", "id": 1088, "trainId": 402},
    {"name": "candelabrum, candelabra", "id": 373, "trainId": 403},
    {"name": "sofa bed", "id": 2472, "trainId": 404},
    {"name": "tunnel", "id": 2892, "trainId": 405},
    {"name": "pallet", "id": 1740, "trainId": 406},
    {"name": "wire, conducting wire", "id": 3067, "trainId": 407},
    {"name": "kettle, boiler", "id": 1367, "trainId": 408},
    {"name": "bidet", "id": 188, "trainId": 409},
    {
        "name": "baby buggy, baby carriage, carriage, perambulator, pram, stroller, go-cart, pushchair, pusher",
        "id": 79,
        "trainId": 410,
    },
    {"name": "music stand", "id": 1633, "trainId": 411},
    {"name": "pipe, tube", "id": 1885, "trainId": 412},
    {"name": "cup", "id": 677, "trainId": 413},
    {"name": "parking meter", "id": 1779, "trainId": 414},
    {"name": "ice hockey rink", "id": 1297, "trainId": 415},
    {"name": "shelter", "id": 2334, "trainId": 416},
    {"name": "weeds", "id": 3027, "trainId": 417},
    {"name": "temple", "id": 2735, "trainId": 418},
    {"name": "patty, cake", "id": 1791, "trainId": 419},
    {"name": "ski slope", "id": 2405, "trainId": 420},
    {"name": "panel", "id": 1748, "trainId": 421},
    {"name": "wallet", "id": 2983, "trainId": 422},
    {"name": "wheel", "id": 3035, "trainId": 423},
    {"name": "towel rack, towel horse", "id": 2824, "trainId": 424},
    {"name": "roundabout", "id": 2168, "trainId": 425},
    {"name": "canister, cannister, tin", "id": 385, "trainId": 426},
    {"name": "rod", "id": 2148, "trainId": 427},
    {"name": "soap dispenser", "id": 2465, "trainId": 428},
    {"name": "bell", "id": 175, "trainId": 429},
    {"name": "canvas", "id": 390, "trainId": 430},
    {"name": "box office, ticket office, ticket booth", "id": 268, "trainId": 431},
    {"name": "teacup", "id": 2722, "trainId": 432},
    {"name": "trellis", "id": 2857, "trainId": 433},
    {"name": "workbench", "id": 3088, "trainId": 434},
    {"name": "valley, vale", "id": 2926, "trainId": 435},
    {"name": "toaster", "id": 2782, "trainId": 436},
    {"name": "knife", "id": 1378, "trainId": 437},
    {"name": "podium", "id": 1934, "trainId": 438},
    {"name": "ramp", "id": 2072, "trainId": 439},
    {"name": "tumble dryer", "id": 2889, "trainId": 440},
    {"name": "fireplug, fire hydrant, plug", "id": 944, "trainId": 441},
    {"name": "gym shoe, sneaker, tennis shoe", "id": 1158, "trainId": 442},
    {"name": "lab bench", "id": 1383, "trainId": 443},
    {"name": "equipment", "id": 867, "trainId": 444},
    {"name": "rocky formation", "id": 2145, "trainId": 445},
    {"name": "plastic", "id": 1915, "trainId": 446},
    {"name": "calendar", "id": 361, "trainId": 447},
    {"name": "caravan", "id": 402, "trainId": 448},
    {"name": "check-in-desk", "id": 482, "trainId": 449},
    {"name": "ticket counter", "id": 2761, "trainId": 450},
    {"name": "brush", "id": 300, "trainId": 451},
    {"name": "mill", "id": 1554, "trainId": 452},
    {"name": "covered bridge", "id": 636, "trainId": 453},
    {"name": "bowling alley", "id": 260, "trainId": 454},
    {"name": "hanger", "id": 1186, "trainId": 455},
    {"name": "excavator", "id": 871, "trainId": 456},
    {"name": "trestle", "id": 2859, "trainId": 457},
    {"name": "revolving door", "id": 2103, "trainId": 458},
    {"name": "blast furnace", "id": 208, "trainId": 459},
    {"name": "scale, weighing machine", "id": 2236, "trainId": 460},
    {"name": "projector", "id": 2012, "trainId": 461},
    {"name": "soap", "id": 2462, "trainId": 462},
    {"name": "locker", "id": 1462, "trainId": 463},
    {"name": "tractor", "id": 2832, "trainId": 464},
    {"name": "stretcher", "id": 2617, "trainId": 465},
    {"name": "frame", "id": 1024, "trainId": 466},
    {"name": "grating", "id": 1129, "trainId": 467},
    {"name": "alembic", "id": 18, "trainId": 468},
    {"name": "candle, taper, wax light", "id": 376, "trainId": 469},
    {"name": "barrier", "id": 134, "trainId": 470},
    {"name": "cardboard", "id": 407, "trainId": 471},
    {"name": "cave", "id": 434, "trainId": 472},
    {"name": "puddle", "id": 2017, "trainId": 473},
    {"name": "tarp", "id": 2717, "trainId": 474},
    {"name": "price tag", "id": 2005, "trainId": 475},
    {"name": "watchtower", "id": 2993, "trainId": 476},
    {"name": "meters", "id": 1545, "trainId": 477},
    {
        "name": "light bulb, lightbulb, bulb, incandescent lamp, electric light, electric-light bulb",
        "id": 1445,
        "trainId": 478,
    },
    {"name": "tracks", "id": 2831, "trainId": 479},
    {"name": "hair dryer", "id": 1161, "trainId": 480},
    {"name": "skirt", "id": 2411, "trainId": 481},
    {"name": "viaduct", "id": 2949, "trainId": 482},
    {"name": "paper towel", "id": 1769, "trainId": 483},
    {"name": "coat", "id": 552, "trainId": 484},
    {"name": "sheet", "id": 2327, "trainId": 485},
    {"name": "fire extinguisher, extinguisher, asphyxiator", "id": 939, "trainId": 486},
    {"name": "water wheel", "id": 3013, "trainId": 487},
    {"name": "pottery, clayware", "id": 1986, "trainId": 488},
    {"name": "magazine rack", "id": 1486, "trainId": 489},
    {"name": "teapot", "id": 2723, "trainId": 490},
    {"name": "microphone, mike", "id": 1549, "trainId": 491},
    {"name": "support", "id": 2649, "trainId": 492},
    {"name": "forklift", "id": 1020, "trainId": 493},
    {"name": "canyon", "id": 392, "trainId": 494},
    {"name": "cash register, register", "id": 422, "trainId": 495},
    {"name": "leaf, leafage, foliage", "id": 1419, "trainId": 496},
    {"name": "remote control, remote", "id": 2099, "trainId": 497},
    {"name": "soap dish", "id": 2464, "trainId": 498},
    {"name": "windshield, windscreen", "id": 3058, "trainId": 499},
    {"name": "cat", "id": 430, "trainId": 500},
    {"name": "cue, cue stick, pool cue, pool stick", "id": 675, "trainId": 501},
    {"name": "vent, venthole, vent-hole, blowhole", "id": 2941, "trainId": 502},
    {"name": "videos", "id": 2955, "trainId": 503},
    {"name": "shovel", "id": 2355, "trainId": 504},
    {"name": "eaves", "id": 840, "trainId": 505},
    {"name": "antenna, aerial, transmitting aerial", "id": 32, "trainId": 506},
    {"name": "shipyard", "id": 2338, "trainId": 507},
    {"name": "hen, biddy", "id": 1232, "trainId": 508},
    {"name": "traffic cone", "id": 2834, "trainId": 509},
    {"name": "washing machines", "id": 2991, "trainId": 510},
    {"name": "truck crane", "id": 2879, "trainId": 511},
    {"name": "cds", "id": 444, "trainId": 512},
    {"name": "niche", "id": 1657, "trainId": 513},
    {"name": "scoreboard", "id": 2246, "trainId": 514},
    {"name": "briefcase", "id": 296, "trainId": 515},
    {"name": "boot", "id": 245, "trainId": 516},
    {"name": "sweater, jumper", "id": 2661, "trainId": 517},
    {"name": "hay", "id": 1202, "trainId": 518},
    {"name": "pack", "id": 1714, "trainId": 519},
    {"name": "bottle rack", "id": 251, "trainId": 520},
    {"name": "glacier", "id": 1095, "trainId": 521},
    {"name": "pergola", "id": 1828, "trainId": 522},
    {"name": "building materials", "id": 311, "trainId": 523},
    {"name": "television camera", "id": 2732, "trainId": 524},
    {"name": "first floor", "id": 947, "trainId": 525},
    {"name": "rifle", "id": 2115, "trainId": 526},
    {"name": "tennis table", "id": 2738, "trainId": 527},
    {"name": "stadium", "id": 2525, "trainId": 528},
    {"name": "safety belt", "id": 2194, "trainId": 529},
    {"name": "cover", "id": 634, "trainId": 530},
    {"name": "dish rack", "id": 740, "trainId": 531},
    {"name": "synthesizer", "id": 2682, "trainId": 532},
    {"name": "pumpkin", "id": 2020, "trainId": 533},
    {"name": "gutter", "id": 1156, "trainId": 534},
    {"name": "fruit stand", "id": 1036, "trainId": 535},
    {"name": "ice floe, floe", "id": 1295, "trainId": 536},
    {"name": "handle, grip, handgrip, hold", "id": 1181, "trainId": 537},
    {"name": "wheelchair", "id": 3037, "trainId": 538},
    {"name": "mousepad, mouse mat", "id": 1614, "trainId": 539},
    {"name": "diploma", "id": 736, "trainId": 540},
    {"name": "fairground ride", "id": 893, "trainId": 541},
    {"name": "radio", "id": 2047, "trainId": 542},
    {"name": "hotplate", "id": 1274, "trainId": 543},
    {"name": "junk", "id": 1361, "trainId": 544},
    {"name": "wheelbarrow", "id": 3036, "trainId": 545},
    {"name": "stream", "id": 2606, "trainId": 546},
    {"name": "toll plaza", "id": 2797, "trainId": 547},
    {"name": "punching bag", "id": 2022, "trainId": 548},
    {"name": "trough", "id": 2876, "trainId": 549},
    {"name": "throne", "id": 2758, "trainId": 550},
    {"name": "chair desk", "id": 472, "trainId": 551},
    {"name": "weighbridge", "id": 3028, "trainId": 552},
    {"name": "extractor fan", "id": 882, "trainId": 553},
    {"name": "hanging clothes", "id": 1189, "trainId": 554},
    {"name": "dish, dish aerial, dish antenna, saucer", "id": 743, "trainId": 555},
    {"name": "alarm clock, alarm", "id": 3122, "trainId": 556},
    {"name": "ski lift", "id": 2401, "trainId": 557},
    {"name": "chain", "id": 468, "trainId": 558},
    {"name": "garage", "id": 1061, "trainId": 559},
    {"name": "mechanical shovel", "id": 1523, "trainId": 560},
    {"name": "wine rack", "id": 3059, "trainId": 561},
    {"name": "tramway", "id": 2843, "trainId": 562},
    {"name": "treadmill", "id": 2853, "trainId": 563},
    {"name": "menu", "id": 1529, "trainId": 564},
    {"name": "block", "id": 214, "trainId": 565},
    {"name": "well", "id": 3032, "trainId": 566},
    {"name": "witness stand", "id": 3071, "trainId": 567},
    {"name": "branch", "id": 277, "trainId": 568},
    {"name": "duck", "id": 813, "trainId": 569},
    {"name": "casserole", "id": 426, "trainId": 570},
    {"name": "frying pan", "id": 1039, "trainId": 571},
    {"name": "desk organizer", "id": 727, "trainId": 572},
    {"name": "mast", "id": 1508, "trainId": 573},
    {"name": "spectacles, specs, eyeglasses, glasses", "id": 2490, "trainId": 574},
    {"name": "service elevator", "id": 2299, "trainId": 575},
    {"name": "dollhouse", "id": 768, "trainId": 576},
    {"name": "hammock", "id": 1172, "trainId": 577},
    {"name": "clothes hanging", "id": 537, "trainId": 578},
    {"name": "photocopier", "id": 1847, "trainId": 579},
    {"name": "notepad", "id": 1664, "trainId": 580},
    {"name": "golf cart", "id": 1110, "trainId": 581},
    {"name": "footpath", "id": 1014, "trainId": 582},
    {"name": "cross", "id": 662, "trainId": 583},
    {"name": "baptismal font", "id": 121, "trainId": 584},
    {"name": "boiler", "id": 227, "trainId": 585},
    {"name": "skip", "id": 2410, "trainId": 586},
    {"name": "rotisserie", "id": 2165, "trainId": 587},
    {"name": "tables", "id": 2696, "trainId": 588},
    {"name": "water mill", "id": 3005, "trainId": 589},
    {"name": "helmet", "id": 1231, "trainId": 590},
    {"name": "cover curtain", "id": 635, "trainId": 591},
    {"name": "brick", "id": 292, "trainId": 592},
    {"name": "table runner", "id": 2690, "trainId": 593},
    {"name": "ashtray", "id": 65, "trainId": 594},
    {"name": "street box", "id": 2607, "trainId": 595},
    {"name": "stick", "id": 2574, "trainId": 596},
    {"name": "hangers", "id": 1188, "trainId": 597},
    {"name": "cells", "id": 456, "trainId": 598},
    {"name": "urinal", "id": 2913, "trainId": 599},
    {"name": "centerpiece", "id": 459, "trainId": 600},
    {"name": "portable fridge", "id": 1955, "trainId": 601},
    {"name": "dvds", "id": 827, "trainId": 602},
    {"name": "golf club", "id": 1111, "trainId": 603},
    {"name": "skirting board", "id": 2412, "trainId": 604},
    {"name": "water cooler", "id": 2997, "trainId": 605},
    {"name": "clipboard", "id": 528, "trainId": 606},
    {"name": "camera, photographic camera", "id": 366, "trainId": 607},
    {"name": "pigeonhole", "id": 1863, "trainId": 608},
    {"name": "chips", "id": 500, "trainId": 609},
    {"name": "food processor", "id": 1001, "trainId": 610},
    {"name": "post box", "id": 1958, "trainId": 611},
    {"name": "lid", "id": 1441, "trainId": 612},
    {"name": "drum", "id": 809, "trainId": 613},
    {"name": "blender", "id": 210, "trainId": 614},
    {"name": "cave entrance", "id": 435, "trainId": 615},
    {"name": "dental chair", "id": 718, "trainId": 616},
    {"name": "obelisk", "id": 1674, "trainId": 617},
    {"name": "canoe", "id": 388, "trainId": 618},
    {"name": "mobile", "id": 1572, "trainId": 619},
    {"name": "monitors", "id": 1584, "trainId": 620},
    {"name": "pool ball", "id": 1944, "trainId": 621},
    {"name": "cue rack", "id": 674, "trainId": 622},
    {"name": "baggage carts", "id": 99, "trainId": 623},
    {"name": "shore", "id": 2352, "trainId": 624},
    {"name": "fork", "id": 1019, "trainId": 625},
    {"name": "paper filer", "id": 1763, "trainId": 626},
    {"name": "bicycle rack", "id": 185, "trainId": 627},
    {"name": "coat rack", "id": 554, "trainId": 628},
    {"name": "garland", "id": 1066, "trainId": 629},
    {"name": "sports bag", "id": 2508, "trainId": 630},
    {"name": "fish tank", "id": 951, "trainId": 631},
    {"name": "towel dispenser", "id": 2822, "trainId": 632},
    {"name": "carriage", "id": 415, "trainId": 633},
    {"name": "brochure", "id": 297, "trainId": 634},
    {"name": "plaque", "id": 1914, "trainId": 635},
    {"name": "stringer", "id": 2619, "trainId": 636},
    {"name": "iron", "id": 1338, "trainId": 637},
    {"name": "spoon", "id": 2505, "trainId": 638},
    {"name": "flag pole", "id": 955, "trainId": 639},
    {"name": "toilet brush", "id": 2786, "trainId": 640},
    {"name": "book stand", "id": 238, "trainId": 641},
    {"name": "water faucet, water tap, tap, hydrant", "id": 3000, "trainId": 642},
    {"name": "ticket office", "id": 2763, "trainId": 643},
    {"name": "broom", "id": 299, "trainId": 644},
    {"name": "dvd", "id": 822, "trainId": 645},
    {"name": "ice bucket", "id": 1288, "trainId": 646},
    {"name": "carapace, shell, cuticle, shield", "id": 3101, "trainId": 647},
    {"name": "tureen", "id": 2894, "trainId": 648},
    {"name": "folders", "id": 992, "trainId": 649},
    {"name": "chess", "id": 489, "trainId": 650},
    {"name": "root", "id": 2157, "trainId": 651},
    {"name": "sewing machine", "id": 2309, "trainId": 652},
    {"name": "model", "id": 1576, "trainId": 653},
    {"name": "pen", "id": 1810, "trainId": 654},
    {"name": "violin", "id": 2964, "trainId": 655},
    {"name": "sweatshirt", "id": 2662, "trainId": 656},
    {"name": "recycling materials", "id": 2087, "trainId": 657},
    {"name": "mitten", "id": 1569, "trainId": 658},
    {"name": "chopping board, cutting board", "id": 503, "trainId": 659},
    {"name": "mask", "id": 1505, "trainId": 660},
    {"name": "log", "id": 1468, "trainId": 661},
    {"name": "mouse, computer mouse", "id": 1613, "trainId": 662},
    {"name": "grill", "id": 1138, "trainId": 663},
    {"name": "hole", "id": 1256, "trainId": 664},
    {"name": "target", "id": 2715, "trainId": 665},
    {"name": "trash bag", "id": 2846, "trainId": 666},
    {"name": "chalk", "id": 477, "trainId": 667},
    {"name": "sticks", "id": 2576, "trainId": 668},
    {"name": "balloon", "id": 108, "trainId": 669},
    {"name": "score", "id": 2245, "trainId": 670},
    {"name": "hair spray", "id": 1162, "trainId": 671},
    {"name": "roll", "id": 2149, "trainId": 672},
    {"name": "runner", "id": 2183, "trainId": 673},
    {"name": "engine", "id": 858, "trainId": 674},
    {"name": "inflatable glove", "id": 1324, "trainId": 675},
    {"name": "games", "id": 1055, "trainId": 676},
    {"name": "pallets", "id": 1741, "trainId": 677},
    {"name": "baskets", "id": 149, "trainId": 678},
    {"name": "coop", "id": 615, "trainId": 679},
    {"name": "dvd player", "id": 825, "trainId": 680},
    {"name": "rocking horse", "id": 2143, "trainId": 681},
    {"name": "buckets", "id": 304, "trainId": 682},
    {"name": "bread rolls", "id": 283, "trainId": 683},
    {"name": "shawl", "id": 2322, "trainId": 684},
    {"name": "watering can", "id": 3017, "trainId": 685},
    {"name": "spotlights", "id": 2510, "trainId": 686},
    {"name": "post-it", "id": 1960, "trainId": 687},
    {"name": "bowls", "id": 265, "trainId": 688},
    {"name": "security camera", "id": 2282, "trainId": 689},
    {"name": "runner cloth", "id": 2184, "trainId": 690},
    {"name": "lock", "id": 1461, "trainId": 691},
    {"name": "alarm, warning device, alarm system", "id": 3113, "trainId": 692},
    {"name": "side", "id": 2372, "trainId": 693},
    {"name": "roulette", "id": 2166, "trainId": 694},
    {"name": "bone", "id": 232, "trainId": 695},
    {"name": "cutlery", "id": 693, "trainId": 696},
    {"name": "pool balls", "id": 1945, "trainId": 697},
    {"name": "wheels", "id": 3039, "trainId": 698},
    {"name": "spice rack", "id": 2494, "trainId": 699},
    {"name": "plant pots", "id": 1908, "trainId": 700},
    {"name": "towel ring", "id": 2827, "trainId": 701},
    {"name": "bread box", "id": 280, "trainId": 702},
    {"name": "video", "id": 2950, "trainId": 703},
    {"name": "funfair", "id": 1044, "trainId": 704},
    {"name": "breads", "id": 288, "trainId": 705},
    {"name": "tripod", "id": 2863, "trainId": 706},
    {"name": "ironing board", "id": 1342, "trainId": 707},
    {"name": "skimmer", "id": 2409, "trainId": 708},
    {"name": "hollow", "id": 1258, "trainId": 709},
    {"name": "scratching post", "id": 2249, "trainId": 710},
    {"name": "tricycle", "id": 2862, "trainId": 711},
    {"name": "file box", "id": 920, "trainId": 712},
    {"name": "mountain pass", "id": 1607, "trainId": 713},
    {"name": "tombstones", "id": 2802, "trainId": 714},
    {"name": "cooker", "id": 610, "trainId": 715},
    {"name": "card game, cards", "id": 3129, "trainId": 716},
    {"name": "golf bag", "id": 1108, "trainId": 717},
    {"name": "towel paper", "id": 2823, "trainId": 718},
    {"name": "chaise lounge", "id": 476, "trainId": 719},
    {"name": "sun", "id": 2641, "trainId": 720},
    {"name": "toilet paper holder", "id": 2788, "trainId": 721},
    {"name": "rake", "id": 2070, "trainId": 722},
    {"name": "key", "id": 1368, "trainId": 723},
    {"name": "umbrella stand", "id": 2903, "trainId": 724},
    {"name": "dartboard", "id": 699, "trainId": 725},
    {"name": "transformer", "id": 2844, "trainId": 726},
    {"name": "fireplace utensils", "id": 942, "trainId": 727},
    {"name": "sweatshirts", "id": 2663, "trainId": 728},
    {
        "name": "cellular telephone, cellular phone, cellphone, cell, mobile phone",
        "id": 457,
        "trainId": 729,
    },
    {"name": "tallboy", "id": 2701, "trainId": 730},
    {"name": "stapler", "id": 2540, "trainId": 731},
    {"name": "sauna", "id": 2231, "trainId": 732},
    {"name": "test tube", "id": 2746, "trainId": 733},
    {"name": "palette", "id": 1738, "trainId": 734},
    {"name": "shopping carts", "id": 2350, "trainId": 735},
    {"name": "tools", "id": 2808, "trainId": 736},
    {"name": "push button, push, button", "id": 2025, "trainId": 737},
    {"name": "star", "id": 2541, "trainId": 738},
    {"name": "roof rack", "id": 2156, "trainId": 739},
    {"name": "barbed wire", "id": 126, "trainId": 740},
    {"name": "spray", "id": 2512, "trainId": 741},
    {"name": "ear", "id": 831, "trainId": 742},
    {"name": "sponge", "id": 2503, "trainId": 743},
    {"name": "racket", "id": 2039, "trainId": 744},
    {"name": "tins", "id": 2774, "trainId": 745},
    {"name": "eyeglasses", "id": 886, "trainId": 746},
    {"name": "file", "id": 919, "trainId": 747},
    {"name": "scarfs", "id": 2240, "trainId": 748},
    {"name": "sugar bowl", "id": 2636, "trainId": 749},
    {"name": "flip flop", "id": 963, "trainId": 750},
    {"name": "headstones", "id": 1218, "trainId": 751},
    {"name": "laptop bag", "id": 1406, "trainId": 752},
    {"name": "leash", "id": 1420, "trainId": 753},
    {"name": "climbing frame", "id": 526, "trainId": 754},
    {"name": "suit hanger", "id": 2639, "trainId": 755},
    {"name": "floor spotlight", "id": 975, "trainId": 756},
    {"name": "plate rack", "id": 1921, "trainId": 757},
    {"name": "sewer", "id": 2305, "trainId": 758},
    {"name": "hard drive", "id": 1193, "trainId": 759},
    {"name": "sprinkler", "id": 2517, "trainId": 760},
    {"name": "tools box", "id": 2809, "trainId": 761},
    {"name": "necklace", "id": 1647, "trainId": 762},
    {"name": "bulbs", "id": 314, "trainId": 763},
    {"name": "steel industry", "id": 2560, "trainId": 764},
    {"name": "club", "id": 545, "trainId": 765},
    {"name": "jack", "id": 1345, "trainId": 766},
    {"name": "door bars", "id": 775, "trainId": 767},
    {
        "name": "control panel, instrument panel, control board, board, panel",
        "id": 603,
        "trainId": 768,
    },
    {"name": "hairbrush", "id": 1163, "trainId": 769},
    {"name": "napkin holder", "id": 1641, "trainId": 770},
    {"name": "office", "id": 1678, "trainId": 771},
    {"name": "smoke detector", "id": 2450, "trainId": 772},
    {"name": "utensils", "id": 2915, "trainId": 773},
    {"name": "apron", "id": 42, "trainId": 774},
    {"name": "scissors", "id": 2242, "trainId": 775},
    {"name": "terminal", "id": 2741, "trainId": 776},
    {"name": "grinder", "id": 1143, "trainId": 777},
    {"name": "entry phone", "id": 862, "trainId": 778},
    {"name": "newspaper stand", "id": 1654, "trainId": 779},
    {"name": "pepper shaker", "id": 1826, "trainId": 780},
    {"name": "onions", "id": 1689, "trainId": 781},
    {
        "name": "central processing unit, cpu, c p u , central processor, processor, mainframe",
        "id": 3124,
        "trainId": 782,
    },
    {"name": "tape", "id": 2710, "trainId": 783},
    {"name": "bat", "id": 152, "trainId": 784},
    {"name": "coaster", "id": 549, "trainId": 785},
    {"name": "calculator", "id": 360, "trainId": 786},
    {"name": "potatoes", "id": 1982, "trainId": 787},
    {"name": "luggage rack", "id": 1478, "trainId": 788},
    {"name": "salt", "id": 2203, "trainId": 789},
    {"name": "street number", "id": 2612, "trainId": 790},
    {"name": "viewpoint", "id": 2956, "trainId": 791},
    {"name": "sword", "id": 2681, "trainId": 792},
    {"name": "cd", "id": 437, "trainId": 793},
    {"name": "rowing machine", "id": 2171, "trainId": 794},
    {"name": "plug", "id": 1933, "trainId": 795},
    {"name": "andiron, firedog, dog, dog-iron", "id": 3110, "trainId": 796},
    {"name": "pepper", "id": 1824, "trainId": 797},
    {"name": "tongs", "id": 2803, "trainId": 798},
    {"name": "bonfire", "id": 234, "trainId": 799},
    {"name": "dog dish", "id": 764, "trainId": 800},
    {"name": "belt", "id": 177, "trainId": 801},
    {"name": "dumbbells", "id": 817, "trainId": 802},
    {"name": "videocassette recorder, vcr", "id": 3145, "trainId": 803},
    {"name": "hook", "id": 1262, "trainId": 804},
    {"name": "envelopes", "id": 864, "trainId": 805},
    {"name": "shower faucet", "id": 2359, "trainId": 806},
    {"name": "watch", "id": 2992, "trainId": 807},
    {"name": "padlock", "id": 1725, "trainId": 808},
    {"name": "swimming pool ladder", "id": 2667, "trainId": 809},
    {"name": "spanners", "id": 2484, "trainId": 810},
    {"name": "gravy boat", "id": 1133, "trainId": 811},
    {"name": "notice board", "id": 1667, "trainId": 812},
    {"name": "trash bags", "id": 2847, "trainId": 813},
    {"name": "fire alarm", "id": 932, "trainId": 814},
    {"name": "ladle", "id": 1392, "trainId": 815},
    {"name": "stethoscope", "id": 2573, "trainId": 816},
    {"name": "rocket", "id": 2140, "trainId": 817},
    {"name": "funnel", "id": 1046, "trainId": 818},
    {"name": "bowling pins", "id": 264, "trainId": 819},
    {"name": "valve", "id": 2927, "trainId": 820},
    {"name": "thermometer", "id": 2752, "trainId": 821},
    {"name": "cups", "id": 679, "trainId": 822},
    {"name": "spice jar", "id": 2493, "trainId": 823},
    {"name": "night light", "id": 1658, "trainId": 824},
    {"name": "soaps", "id": 2466, "trainId": 825},
    {"name": "games table", "id": 1057, "trainId": 826},
    {"name": "slotted spoon", "id": 2444, "trainId": 827},
    {"name": "reel", "id": 2093, "trainId": 828},
    {"name": "scourer", "id": 2248, "trainId": 829},
    {"name": "sleeping robe", "id": 2432, "trainId": 830},
    {"name": "desk mat", "id": 726, "trainId": 831},
    {"name": "dumbbell", "id": 816, "trainId": 832},
    {"name": "hammer", "id": 1171, "trainId": 833},
    {"name": "tie", "id": 2766, "trainId": 834},
    {"name": "typewriter", "id": 2900, "trainId": 835},
    {"name": "shaker", "id": 2313, "trainId": 836},
    {"name": "cheese dish", "id": 488, "trainId": 837},
    {"name": "sea star", "id": 2265, "trainId": 838},
    {"name": "racquet", "id": 2043, "trainId": 839},
    {"name": "butane gas cylinder", "id": 332, "trainId": 840},
    {"name": "paper weight", "id": 1771, "trainId": 841},
    {"name": "shaving brush", "id": 2320, "trainId": 842},
    {"name": "sunglasses", "id": 2646, "trainId": 843},
    {"name": "gear shift", "id": 1089, "trainId": 844},
    {"name": "towel rail", "id": 2826, "trainId": 845},
    {"name": "adding machine, totalizer, totaliser", "id": 3148, "trainId": 846},
]

PASCAL_VOC_21_CATEGORIES = [
    {"color": [0, 0, 0], "id": 0, "isthing": 1, "name": "background"},
    {"color": [128, 0, 0], "id": 1, "isthing": 1, "name": "aeroplane"},
    {"color": [0, 128, 0], "id": 2, "isthing": 1, "name": "bicycle"},
    {"color": [128, 128, 0], "id": 3, "isthing": 1, "name": "bird"},
    {"color": [0, 0, 128], "id": 4, "isthing": 1, "name": "boat"},
    {"color": [128, 0, 128], "id": 5, "isthing": 1, "name": "bottle"},
    {"color": [0, 128, 128], "id": 6, "isthing": 1, "name": "bus"},
    {"color": [128, 128, 128], "id": 7, "isthing": 1, "name": "car"},
    {"color": [64, 0, 0], "id": 8, "isthing": 1, "name": "cat"},
    {"color": [192, 0, 0], "id": 9, "isthing": 1, "name": "chair"},
    {"color": [64, 128, 0], "id": 10, "isthing": 1, "name": "cow"},
    {"color": [192, 128, 0], "id": 11, "isthing": 1, "name": "diningtable"},
    {"color": [64, 0, 128], "id": 12, "isthing": 1, "name": "dog"},
    {"color": [192, 0, 128], "id": 13, "isthing": 1, "name": "horse"},
    {"color": [64, 128, 128], "id": 14, "isthing": 1, "name": "motorbike"},
    {"color": [192, 128, 128], "id": 15, "isthing": 1, "name": "person"},
    {"color": [0, 64, 0], "id": 16, "isthing": 1, "name": "pottedplant"},
    {"color": [128, 64, 0], "id": 17, "isthing": 1, "name": "sheep"},
    {"color": [0, 192, 0], "id": 18, "isthing": 1, "name": "sofa"},
    {"color": [128, 192, 0], "id": 19, "isthing": 1, "name": "train"},
    {"color": [0, 64, 128], "id": 20, "isthing": 1, "name": "tvmonitor"},
]

PASCAL_CTX_459_CATEGORIES = [
    {"color": [120, 120, 120], "id": 0, "isthing": 0, "name": "accordion"},
    {"color": [180, 120, 120], "id": 1, "isthing": 0, "name": "aeroplane"},
    {"color": [6, 230, 230], "id": 2, "isthing": 0, "name": "air conditioner"},
    {"color": [80, 50, 50], "id": 3, "isthing": 0, "name": "antenna"},
    {"color": [4, 200, 3], "id": 4, "isthing": 0, "name": "artillery"},
    {"color": [120, 120, 80], "id": 5, "isthing": 0, "name": "ashtray"},
    {"color": [140, 140, 140], "id": 6, "isthing": 0, "name": "atrium"},
    {"color": [204, 5, 255], "id": 7, "isthing": 0, "name": "baby carriage"},
    {"color": [230, 230, 230], "id": 8, "isthing": 0, "name": "bag"},
    {"color": [4, 250, 7], "id": 9, "isthing": 0, "name": "ball"},
    {"color": [224, 5, 255], "id": 10, "isthing": 0, "name": "balloon"},
    {"color": [235, 255, 7], "id": 11, "isthing": 0, "name": "bamboo weaving"},
    {"color": [150, 5, 61], "id": 12, "isthing": 0, "name": "barrel"},
    {"color": [120, 120, 70], "id": 13, "isthing": 0, "name": "baseball bat"},
    {"color": [8, 255, 51], "id": 14, "isthing": 0, "name": "basket"},
    {"color": [255, 6, 82], "id": 15, "isthing": 0, "name": "basketball backboard"},
    {"color": [143, 255, 140], "id": 16, "isthing": 0, "name": "bathtub"},
    {"color": [204, 255, 4], "id": 17, "isthing": 0, "name": "bed"},
    {"color": [255, 51, 7], "id": 18, "isthing": 0, "name": "bedclothes"},
    {"color": [204, 70, 3], "id": 19, "isthing": 0, "name": "beer"},
    {"color": [0, 102, 200], "id": 20, "isthing": 0, "name": "bell"},
    {"color": [61, 230, 250], "id": 21, "isthing": 0, "name": "bench"},
    {"color": [255, 6, 51], "id": 22, "isthing": 0, "name": "bicycle"},
    {"color": [11, 102, 255], "id": 23, "isthing": 0, "name": "binoculars"},
    {"color": [255, 7, 71], "id": 24, "isthing": 0, "name": "bird"},
    {"color": [255, 9, 224], "id": 25, "isthing": 0, "name": "bird cage"},
    {"color": [9, 7, 230], "id": 26, "isthing": 0, "name": "bird feeder"},
    {"color": [220, 220, 220], "id": 27, "isthing": 0, "name": "bird nest"},
    {"color": [255, 9, 92], "id": 28, "isthing": 0, "name": "blackboard"},
    {"color": [112, 9, 255], "id": 29, "isthing": 0, "name": "board"},
    {"color": [8, 255, 214], "id": 30, "isthing": 0, "name": "boat"},
    {"color": [7, 255, 224], "id": 31, "isthing": 0, "name": "bone"},
    {"color": [255, 184, 6], "id": 32, "isthing": 0, "name": "book"},
    {"color": [10, 255, 71], "id": 33, "isthing": 0, "name": "bottle"},
    {"color": [255, 41, 10], "id": 34, "isthing": 0, "name": "bottle opener"},
    {"color": [7, 255, 255], "id": 35, "isthing": 0, "name": "bowl"},
    {"color": [224, 255, 8], "id": 36, "isthing": 0, "name": "box"},
    {"color": [102, 8, 255], "id": 37, "isthing": 0, "name": "bracelet"},
    {"color": [255, 61, 6], "id": 38, "isthing": 0, "name": "brick"},
    {"color": [255, 194, 7], "id": 39, "isthing": 0, "name": "bridge"},
    {"color": [255, 122, 8], "id": 40, "isthing": 0, "name": "broom"},
    {"color": [0, 255, 20], "id": 41, "isthing": 0, "name": "brush"},
    {"color": [255, 8, 41], "id": 42, "isthing": 0, "name": "bucket"},
    {"color": [255, 5, 153], "id": 43, "isthing": 0, "name": "building"},
    {"color": [6, 51, 255], "id": 44, "isthing": 0, "name": "bus"},
    {"color": [235, 12, 255], "id": 45, "isthing": 0, "name": "cabinet"},
    {"color": [160, 150, 20], "id": 46, "isthing": 0, "name": "cabinet door"},
    {"color": [0, 163, 255], "id": 47, "isthing": 0, "name": "cage"},
    {"color": [140, 140, 140], "id": 48, "isthing": 0, "name": "cake"},
    {"color": [250, 10, 15], "id": 49, "isthing": 0, "name": "calculator"},
    {"color": [20, 255, 0], "id": 50, "isthing": 0, "name": "calendar"},
    {"color": [31, 255, 0], "id": 51, "isthing": 0, "name": "camel"},
    {"color": [255, 31, 0], "id": 52, "isthing": 0, "name": "camera"},
    {"color": [255, 224, 0], "id": 53, "isthing": 0, "name": "camera lens"},
    {"color": [153, 255, 0], "id": 54, "isthing": 0, "name": "can"},
    {"color": [0, 0, 255], "id": 55, "isthing": 0, "name": "candle"},
    {"color": [255, 71, 0], "id": 56, "isthing": 0, "name": "candle holder"},
    {"color": [0, 235, 255], "id": 57, "isthing": 0, "name": "cap"},
    {"color": [0, 173, 255], "id": 58, "isthing": 0, "name": "car"},
    {"color": [31, 0, 255], "id": 59, "isthing": 0, "name": "card"},
    {"color": [120, 120, 120], "id": 60, "isthing": 0, "name": "cart"},
    {"color": [180, 120, 120], "id": 61, "isthing": 0, "name": "case"},
    {"color": [6, 230, 230], "id": 62, "isthing": 0, "name": "casette recorder"},
    {"color": [80, 50, 50], "id": 63, "isthing": 0, "name": "cash register"},
    {"color": [4, 200, 3], "id": 64, "isthing": 0, "name": "cat"},
    {"color": [120, 120, 80], "id": 65, "isthing": 0, "name": "cd"},
    {"color": [140, 140, 140], "id": 66, "isthing": 0, "name": "cd player"},
    {"color": [204, 5, 255], "id": 67, "isthing": 0, "name": "ceiling"},
    {"color": [230, 230, 230], "id": 68, "isthing": 0, "name": "cell phone"},
    {"color": [4, 250, 7], "id": 69, "isthing": 0, "name": "cello"},
    {"color": [224, 5, 255], "id": 70, "isthing": 0, "name": "chain"},
    {"color": [235, 255, 7], "id": 71, "isthing": 0, "name": "chair"},
    {"color": [150, 5, 61], "id": 72, "isthing": 0, "name": "chessboard"},
    {"color": [120, 120, 70], "id": 73, "isthing": 0, "name": "chicken"},
    {"color": [8, 255, 51], "id": 74, "isthing": 0, "name": "chopstick"},
    {"color": [255, 6, 82], "id": 75, "isthing": 0, "name": "clip"},
    {"color": [143, 255, 140], "id": 76, "isthing": 0, "name": "clippers"},
    {"color": [204, 255, 4], "id": 77, "isthing": 0, "name": "clock"},
    {"color": [255, 51, 7], "id": 78, "isthing": 0, "name": "closet"},
    {"color": [204, 70, 3], "id": 79, "isthing": 0, "name": "cloth"},
    {"color": [0, 102, 200], "id": 80, "isthing": 0, "name": "clothes tree"},
    {"color": [61, 230, 250], "id": 81, "isthing": 0, "name": "coffee"},
    {"color": [255, 6, 51], "id": 82, "isthing": 0, "name": "coffee machine"},
    {"color": [11, 102, 255], "id": 83, "isthing": 0, "name": "comb"},
    {"color": [255, 7, 71], "id": 84, "isthing": 0, "name": "computer"},
    {"color": [255, 9, 224], "id": 85, "isthing": 0, "name": "concrete"},
    {"color": [9, 7, 230], "id": 86, "isthing": 0, "name": "cone"},
    {"color": [220, 220, 220], "id": 87, "isthing": 0, "name": "container"},
    {"color": [255, 9, 92], "id": 88, "isthing": 0, "name": "control booth"},
    {"color": [112, 9, 255], "id": 89, "isthing": 0, "name": "controller"},
    {"color": [8, 255, 214], "id": 90, "isthing": 0, "name": "cooker"},
    {"color": [7, 255, 224], "id": 91, "isthing": 0, "name": "copying machine"},
    {"color": [255, 184, 6], "id": 92, "isthing": 0, "name": "coral"},
    {"color": [10, 255, 71], "id": 93, "isthing": 0, "name": "cork"},
    {"color": [255, 41, 10], "id": 94, "isthing": 0, "name": "corkscrew"},
    {"color": [7, 255, 255], "id": 95, "isthing": 0, "name": "counter"},
    {"color": [224, 255, 8], "id": 96, "isthing": 0, "name": "court"},
    {"color": [102, 8, 255], "id": 97, "isthing": 0, "name": "cow"},
    {"color": [255, 61, 6], "id": 98, "isthing": 0, "name": "crabstick"},
    {"color": [255, 194, 7], "id": 99, "isthing": 0, "name": "crane"},
    {"color": [255, 122, 8], "id": 100, "isthing": 0, "name": "crate"},
    {"color": [0, 255, 20], "id": 101, "isthing": 0, "name": "cross"},
    {"color": [255, 8, 41], "id": 102, "isthing": 0, "name": "crutch"},
    {"color": [255, 5, 153], "id": 103, "isthing": 0, "name": "cup"},
    {"color": [6, 51, 255], "id": 104, "isthing": 0, "name": "curtain"},
    {"color": [235, 12, 255], "id": 105, "isthing": 0, "name": "cushion"},
    {"color": [160, 150, 20], "id": 106, "isthing": 0, "name": "cutting board"},
    {"color": [0, 163, 255], "id": 107, "isthing": 0, "name": "dais"},
    {"color": [140, 140, 140], "id": 108, "isthing": 0, "name": "disc"},
    {"color": [250, 10, 15], "id": 109, "isthing": 0, "name": "disc case"},
    {"color": [20, 255, 0], "id": 110, "isthing": 0, "name": "dishwasher"},
    {"color": [31, 255, 0], "id": 111, "isthing": 0, "name": "dock"},
    {"color": [255, 31, 0], "id": 112, "isthing": 0, "name": "dog"},
    {"color": [255, 224, 0], "id": 113, "isthing": 0, "name": "dolphin"},
    {"color": [153, 255, 0], "id": 114, "isthing": 0, "name": "door"},
    {"color": [0, 0, 255], "id": 115, "isthing": 0, "name": "drainer"},
    {"color": [255, 71, 0], "id": 116, "isthing": 0, "name": "dray"},
    {"color": [0, 235, 255], "id": 117, "isthing": 0, "name": "drink dispenser"},
    {"color": [0, 173, 255], "id": 118, "isthing": 0, "name": "drinking machine"},
    {"color": [31, 0, 255], "id": 119, "isthing": 0, "name": "drop"},
    {"color": [120, 120, 120], "id": 120, "isthing": 0, "name": "drug"},
    {"color": [180, 120, 120], "id": 121, "isthing": 0, "name": "drum"},
    {"color": [6, 230, 230], "id": 122, "isthing": 0, "name": "drum kit"},
    {"color": [80, 50, 50], "id": 123, "isthing": 0, "name": "duck"},
    {"color": [4, 200, 3], "id": 124, "isthing": 0, "name": "dumbbell"},
    {"color": [120, 120, 80], "id": 125, "isthing": 0, "name": "earphone"},
    {"color": [140, 140, 140], "id": 126, "isthing": 0, "name": "earrings"},
    {"color": [204, 5, 255], "id": 127, "isthing": 0, "name": "egg"},
    {"color": [230, 230, 230], "id": 128, "isthing": 0, "name": "electric fan"},
    {"color": [4, 250, 7], "id": 129, "isthing": 0, "name": "electric iron"},
    {"color": [224, 5, 255], "id": 130, "isthing": 0, "name": "electric pot"},
    {"color": [235, 255, 7], "id": 131, "isthing": 0, "name": "electric saw"},
    {"color": [150, 5, 61], "id": 132, "isthing": 0, "name": "electronic keyboard"},
    {"color": [120, 120, 70], "id": 133, "isthing": 0, "name": "engine"},
    {"color": [8, 255, 51], "id": 134, "isthing": 0, "name": "envelope"},
    {"color": [255, 6, 82], "id": 135, "isthing": 0, "name": "equipment"},
    {"color": [143, 255, 140], "id": 136, "isthing": 0, "name": "escalator"},
    {"color": [204, 255, 4], "id": 137, "isthing": 0, "name": "exhibition booth"},
    {"color": [255, 51, 7], "id": 138, "isthing": 0, "name": "extinguisher"},
    {"color": [204, 70, 3], "id": 139, "isthing": 0, "name": "eyeglass"},
    {"color": [0, 102, 200], "id": 140, "isthing": 0, "name": "fan"},
    {"color": [61, 230, 250], "id": 141, "isthing": 0, "name": "faucet"},
    {"color": [255, 6, 51], "id": 142, "isthing": 0, "name": "fax machine"},
    {"color": [11, 102, 255], "id": 143, "isthing": 0, "name": "fence"},
    {"color": [255, 7, 71], "id": 144, "isthing": 0, "name": "ferris wheel"},
    {"color": [255, 9, 224], "id": 145, "isthing": 0, "name": "fire extinguisher"},
    {"color": [9, 7, 230], "id": 146, "isthing": 0, "name": "fire hydrant"},
    {"color": [220, 220, 220], "id": 147, "isthing": 0, "name": "fire place"},
    {"color": [255, 9, 92], "id": 148, "isthing": 0, "name": "fish"},
    {"color": [112, 9, 255], "id": 149, "isthing": 0, "name": "fish tank"},
    {"color": [8, 255, 214], "id": 150, "isthing": 0, "name": "fishbowl"},
    {"color": [7, 255, 224], "id": 151, "isthing": 0, "name": "fishing net"},
    {"color": [255, 184, 6], "id": 152, "isthing": 0, "name": "fishing pole"},
    {"color": [10, 255, 71], "id": 153, "isthing": 0, "name": "flag"},
    {"color": [255, 41, 10], "id": 154, "isthing": 0, "name": "flagstaff"},
    {"color": [7, 255, 255], "id": 155, "isthing": 0, "name": "flame"},
    {"color": [224, 255, 8], "id": 156, "isthing": 0, "name": "flashlight"},
    {"color": [102, 8, 255], "id": 157, "isthing": 0, "name": "floor"},
    {"color": [255, 61, 6], "id": 158, "isthing": 0, "name": "flower"},
    {"color": [255, 194, 7], "id": 159, "isthing": 0, "name": "fly"},
    {"color": [255, 122, 8], "id": 160, "isthing": 0, "name": "foam"},
    {"color": [0, 255, 20], "id": 161, "isthing": 0, "name": "food"},
    {"color": [255, 8, 41], "id": 162, "isthing": 0, "name": "footbridge"},
    {"color": [255, 5, 153], "id": 163, "isthing": 0, "name": "forceps"},
    {"color": [6, 51, 255], "id": 164, "isthing": 0, "name": "fork"},
    {"color": [235, 12, 255], "id": 165, "isthing": 0, "name": "forklift"},
    {"color": [160, 150, 20], "id": 166, "isthing": 0, "name": "fountain"},
    {"color": [0, 163, 255], "id": 167, "isthing": 0, "name": "fox"},
    {"color": [140, 140, 140], "id": 168, "isthing": 0, "name": "frame"},
    {"color": [250, 10, 15], "id": 169, "isthing": 0, "name": "fridge"},
    {"color": [20, 255, 0], "id": 170, "isthing": 0, "name": "frog"},
    {"color": [31, 255, 0], "id": 171, "isthing": 0, "name": "fruit"},
    {"color": [255, 31, 0], "id": 172, "isthing": 0, "name": "funnel"},
    {"color": [255, 224, 0], "id": 173, "isthing": 0, "name": "furnace"},
    {"color": [153, 255, 0], "id": 174, "isthing": 0, "name": "game controller"},
    {"color": [0, 0, 255], "id": 175, "isthing": 0, "name": "game machine"},
    {"color": [255, 71, 0], "id": 176, "isthing": 0, "name": "gas cylinder"},
    {"color": [0, 235, 255], "id": 177, "isthing": 0, "name": "gas hood"},
    {"color": [0, 173, 255], "id": 178, "isthing": 0, "name": "gas stove"},
    {"color": [31, 0, 255], "id": 179, "isthing": 0, "name": "gift box"},
    {"color": [120, 120, 120], "id": 180, "isthing": 0, "name": "glass"},
    {"color": [180, 120, 120], "id": 181, "isthing": 0, "name": "glass marble"},
    {"color": [6, 230, 230], "id": 182, "isthing": 0, "name": "globe"},
    {"color": [80, 50, 50], "id": 183, "isthing": 0, "name": "glove"},
    {"color": [4, 200, 3], "id": 184, "isthing": 0, "name": "goal"},
    {"color": [120, 120, 80], "id": 185, "isthing": 0, "name": "grandstand"},
    {"color": [140, 140, 140], "id": 186, "isthing": 0, "name": "grass"},
    {"color": [204, 5, 255], "id": 187, "isthing": 0, "name": "gravestone"},
    {"color": [230, 230, 230], "id": 188, "isthing": 0, "name": "ground"},
    {"color": [4, 250, 7], "id": 189, "isthing": 0, "name": "guardrail"},
    {"color": [224, 5, 255], "id": 190, "isthing": 0, "name": "guitar"},
    {"color": [235, 255, 7], "id": 191, "isthing": 0, "name": "gun"},
    {"color": [150, 5, 61], "id": 192, "isthing": 0, "name": "hammer"},
    {"color": [120, 120, 70], "id": 193, "isthing": 0, "name": "hand cart"},
    {"color": [8, 255, 51], "id": 194, "isthing": 0, "name": "handle"},
    {"color": [255, 6, 82], "id": 195, "isthing": 0, "name": "handrail"},
    {"color": [143, 255, 140], "id": 196, "isthing": 0, "name": "hanger"},
    {"color": [204, 255, 4], "id": 197, "isthing": 0, "name": "hard disk drive"},
    {"color": [255, 51, 7], "id": 198, "isthing": 0, "name": "hat"},
    {"color": [204, 70, 3], "id": 199, "isthing": 0, "name": "hay"},
    {"color": [0, 102, 200], "id": 200, "isthing": 0, "name": "headphone"},
    {"color": [61, 230, 250], "id": 201, "isthing": 0, "name": "heater"},
    {"color": [255, 6, 51], "id": 202, "isthing": 0, "name": "helicopter"},
    {"color": [11, 102, 255], "id": 203, "isthing": 0, "name": "helmet"},
    {"color": [255, 7, 71], "id": 204, "isthing": 0, "name": "holder"},
    {"color": [255, 9, 224], "id": 205, "isthing": 0, "name": "hook"},
    {"color": [9, 7, 230], "id": 206, "isthing": 0, "name": "horse"},
    {"color": [220, 220, 220], "id": 207, "isthing": 0, "name": "horse-drawn carriage"},
    {"color": [255, 9, 92], "id": 208, "isthing": 0, "name": "hot-air balloon"},
    {"color": [112, 9, 255], "id": 209, "isthing": 0, "name": "hydrovalve"},
    {"color": [8, 255, 214], "id": 210, "isthing": 0, "name": "ice"},
    {"color": [7, 255, 224], "id": 211, "isthing": 0, "name": "inflator pump"},
    {"color": [255, 184, 6], "id": 212, "isthing": 0, "name": "ipod"},
    {"color": [10, 255, 71], "id": 213, "isthing": 0, "name": "iron"},
    {"color": [255, 41, 10], "id": 214, "isthing": 0, "name": "ironing board"},
    {"color": [7, 255, 255], "id": 215, "isthing": 0, "name": "jar"},
    {"color": [224, 255, 8], "id": 216, "isthing": 0, "name": "kart"},
    {"color": [102, 8, 255], "id": 217, "isthing": 0, "name": "kettle"},
    {"color": [255, 61, 6], "id": 218, "isthing": 0, "name": "key"},
    {"color": [255, 194, 7], "id": 219, "isthing": 0, "name": "keyboard"},
    {"color": [255, 122, 8], "id": 220, "isthing": 0, "name": "kitchen range"},
    {"color": [0, 255, 20], "id": 221, "isthing": 0, "name": "kite"},
    {"color": [255, 8, 41], "id": 222, "isthing": 0, "name": "knife"},
    {"color": [255, 5, 153], "id": 223, "isthing": 0, "name": "knife block"},
    {"color": [6, 51, 255], "id": 224, "isthing": 0, "name": "ladder"},
    {"color": [235, 12, 255], "id": 225, "isthing": 0, "name": "ladder truck"},
    {"color": [160, 150, 20], "id": 226, "isthing": 0, "name": "ladle"},
    {"color": [0, 163, 255], "id": 227, "isthing": 0, "name": "laptop"},
    {"color": [140, 140, 140], "id": 228, "isthing": 0, "name": "leaves"},
    {"color": [250, 10, 15], "id": 229, "isthing": 0, "name": "lid"},
    {"color": [20, 255, 0], "id": 230, "isthing": 0, "name": "life buoy"},
    {"color": [31, 255, 0], "id": 231, "isthing": 0, "name": "light"},
    {"color": [255, 31, 0], "id": 232, "isthing": 0, "name": "light bulb"},
    {"color": [255, 224, 0], "id": 233, "isthing": 0, "name": "lighter"},
    {"color": [153, 255, 0], "id": 234, "isthing": 0, "name": "line"},
    {"color": [0, 0, 255], "id": 235, "isthing": 0, "name": "lion"},
    {"color": [255, 71, 0], "id": 236, "isthing": 0, "name": "lobster"},
    {"color": [0, 235, 255], "id": 237, "isthing": 0, "name": "lock"},
    {"color": [0, 173, 255], "id": 238, "isthing": 0, "name": "machine"},
    {"color": [31, 0, 255], "id": 239, "isthing": 0, "name": "mailbox"},
    {"color": [120, 120, 120], "id": 240, "isthing": 0, "name": "mannequin"},
    {"color": [180, 120, 120], "id": 241, "isthing": 0, "name": "map"},
    {"color": [6, 230, 230], "id": 242, "isthing": 0, "name": "mask"},
    {"color": [80, 50, 50], "id": 243, "isthing": 0, "name": "mat"},
    {"color": [4, 200, 3], "id": 244, "isthing": 0, "name": "match book"},
    {"color": [120, 120, 80], "id": 245, "isthing": 0, "name": "mattress"},
    {"color": [140, 140, 140], "id": 246, "isthing": 0, "name": "menu"},
    {"color": [204, 5, 255], "id": 247, "isthing": 0, "name": "metal"},
    {"color": [230, 230, 230], "id": 248, "isthing": 0, "name": "meter box"},
    {"color": [4, 250, 7], "id": 249, "isthing": 0, "name": "microphone"},
    {"color": [224, 5, 255], "id": 250, "isthing": 0, "name": "microwave"},
    {"color": [235, 255, 7], "id": 251, "isthing": 0, "name": "mirror"},
    {"color": [150, 5, 61], "id": 252, "isthing": 0, "name": "missile"},
    {"color": [120, 120, 70], "id": 253, "isthing": 0, "name": "model"},
    {"color": [8, 255, 51], "id": 254, "isthing": 0, "name": "money"},
    {"color": [255, 6, 82], "id": 255, "isthing": 0, "name": "monkey"},
    {"color": [143, 255, 140], "id": 256, "isthing": 0, "name": "mop"},
    {"color": [204, 255, 4], "id": 257, "isthing": 0, "name": "motorbike"},
    {"color": [255, 51, 7], "id": 258, "isthing": 0, "name": "mountain"},
    {"color": [204, 70, 3], "id": 259, "isthing": 0, "name": "mouse"},
    {"color": [0, 102, 200], "id": 260, "isthing": 0, "name": "mouse pad"},
    {"color": [61, 230, 250], "id": 261, "isthing": 0, "name": "musical instrument"},
    {"color": [255, 6, 51], "id": 262, "isthing": 0, "name": "napkin"},
    {"color": [11, 102, 255], "id": 263, "isthing": 0, "name": "net"},
    {"color": [255, 7, 71], "id": 264, "isthing": 0, "name": "newspaper"},
    {"color": [255, 9, 224], "id": 265, "isthing": 0, "name": "oar"},
    {"color": [9, 7, 230], "id": 266, "isthing": 0, "name": "ornament"},
    {"color": [220, 220, 220], "id": 267, "isthing": 0, "name": "outlet"},
    {"color": [255, 9, 92], "id": 268, "isthing": 0, "name": "oven"},
    {"color": [112, 9, 255], "id": 269, "isthing": 0, "name": "oxygen bottle"},
    {"color": [8, 255, 214], "id": 270, "isthing": 0, "name": "pack"},
    {"color": [7, 255, 224], "id": 271, "isthing": 0, "name": "pan"},
    {"color": [255, 184, 6], "id": 272, "isthing": 0, "name": "paper"},
    {"color": [10, 255, 71], "id": 273, "isthing": 0, "name": "paper box"},
    {"color": [255, 41, 10], "id": 274, "isthing": 0, "name": "paper cutter"},
    {"color": [7, 255, 255], "id": 275, "isthing": 0, "name": "parachute"},
    {"color": [224, 255, 8], "id": 276, "isthing": 0, "name": "parasol"},
    {"color": [102, 8, 255], "id": 277, "isthing": 0, "name": "parterre"},
    {"color": [255, 61, 6], "id": 278, "isthing": 0, "name": "patio"},
    {"color": [255, 194, 7], "id": 279, "isthing": 0, "name": "pelage"},
    {"color": [255, 122, 8], "id": 280, "isthing": 0, "name": "pen"},
    {"color": [0, 255, 20], "id": 281, "isthing": 0, "name": "pen container"},
    {"color": [255, 8, 41], "id": 282, "isthing": 0, "name": "pencil"},
    {"color": [255, 5, 153], "id": 283, "isthing": 0, "name": "person"},
    {"color": [6, 51, 255], "id": 284, "isthing": 0, "name": "photo"},
    {"color": [235, 12, 255], "id": 285, "isthing": 0, "name": "piano"},
    {"color": [160, 150, 20], "id": 286, "isthing": 0, "name": "picture"},
    {"color": [0, 163, 255], "id": 287, "isthing": 0, "name": "pig"},
    {"color": [140, 140, 140], "id": 288, "isthing": 0, "name": "pillar"},
    {"color": [250, 10, 15], "id": 289, "isthing": 0, "name": "pillow"},
    {"color": [20, 255, 0], "id": 290, "isthing": 0, "name": "pipe"},
    {"color": [31, 255, 0], "id": 291, "isthing": 0, "name": "pitcher"},
    {"color": [255, 31, 0], "id": 292, "isthing": 0, "name": "plant"},
    {"color": [255, 224, 0], "id": 293, "isthing": 0, "name": "plastic"},
    {"color": [153, 255, 0], "id": 294, "isthing": 0, "name": "plate"},
    {"color": [0, 0, 255], "id": 295, "isthing": 0, "name": "platform"},
    {"color": [255, 71, 0], "id": 296, "isthing": 0, "name": "player"},
    {"color": [0, 235, 255], "id": 297, "isthing": 0, "name": "playground"},
    {"color": [0, 173, 255], "id": 298, "isthing": 0, "name": "pliers"},
    {"color": [31, 0, 255], "id": 299, "isthing": 0, "name": "plume"},
    {"color": [120, 120, 120], "id": 300, "isthing": 0, "name": "poker"},
    {"color": [180, 120, 120], "id": 301, "isthing": 0, "name": "poker chip"},
    {"color": [6, 230, 230], "id": 302, "isthing": 0, "name": "pole"},
    {"color": [80, 50, 50], "id": 303, "isthing": 0, "name": "pool table"},
    {"color": [4, 200, 3], "id": 304, "isthing": 0, "name": "postcard"},
    {"color": [120, 120, 80], "id": 305, "isthing": 0, "name": "poster"},
    {"color": [140, 140, 140], "id": 306, "isthing": 0, "name": "pot"},
    {"color": [204, 5, 255], "id": 307, "isthing": 0, "name": "pottedplant"},
    {"color": [230, 230, 230], "id": 308, "isthing": 0, "name": "printer"},
    {"color": [4, 250, 7], "id": 309, "isthing": 0, "name": "projector"},
    {"color": [224, 5, 255], "id": 310, "isthing": 0, "name": "pumpkin"},
    {"color": [235, 255, 7], "id": 311, "isthing": 0, "name": "rabbit"},
    {"color": [150, 5, 61], "id": 312, "isthing": 0, "name": "racket"},
    {"color": [120, 120, 70], "id": 313, "isthing": 0, "name": "radiator"},
    {"color": [8, 255, 51], "id": 314, "isthing": 0, "name": "radio"},
    {"color": [255, 6, 82], "id": 315, "isthing": 0, "name": "rail"},
    {"color": [143, 255, 140], "id": 316, "isthing": 0, "name": "rake"},
    {"color": [204, 255, 4], "id": 317, "isthing": 0, "name": "ramp"},
    {"color": [255, 51, 7], "id": 318, "isthing": 0, "name": "range hood"},
    {"color": [204, 70, 3], "id": 319, "isthing": 0, "name": "receiver"},
    {"color": [0, 102, 200], "id": 320, "isthing": 0, "name": "recorder"},
    {"color": [61, 230, 250], "id": 321, "isthing": 0, "name": "recreational machines"},
    {"color": [255, 6, 51], "id": 322, "isthing": 0, "name": "remote control"},
    {"color": [11, 102, 255], "id": 323, "isthing": 0, "name": "road"},
    {"color": [255, 7, 71], "id": 324, "isthing": 0, "name": "robot"},
    {"color": [255, 9, 224], "id": 325, "isthing": 0, "name": "rock"},
    {"color": [9, 7, 230], "id": 326, "isthing": 0, "name": "rocket"},
    {"color": [220, 220, 220], "id": 327, "isthing": 0, "name": "rocking horse"},
    {"color": [255, 9, 92], "id": 328, "isthing": 0, "name": "rope"},
    {"color": [112, 9, 255], "id": 329, "isthing": 0, "name": "rug"},
    {"color": [8, 255, 214], "id": 330, "isthing": 0, "name": "ruler"},
    {"color": [7, 255, 224], "id": 331, "isthing": 0, "name": "runway"},
    {"color": [255, 184, 6], "id": 332, "isthing": 0, "name": "saddle"},
    {"color": [10, 255, 71], "id": 333, "isthing": 0, "name": "sand"},
    {"color": [255, 41, 10], "id": 334, "isthing": 0, "name": "saw"},
    {"color": [7, 255, 255], "id": 335, "isthing": 0, "name": "scale"},
    {"color": [224, 255, 8], "id": 336, "isthing": 0, "name": "scanner"},
    {"color": [102, 8, 255], "id": 337, "isthing": 0, "name": "scissors"},
    {"color": [255, 61, 6], "id": 338, "isthing": 0, "name": "scoop"},
    {"color": [255, 194, 7], "id": 339, "isthing": 0, "name": "screen"},
    {"color": [255, 122, 8], "id": 340, "isthing": 0, "name": "screwdriver"},
    {"color": [0, 255, 20], "id": 341, "isthing": 0, "name": "sculpture"},
    {"color": [255, 8, 41], "id": 342, "isthing": 0, "name": "scythe"},
    {"color": [255, 5, 153], "id": 343, "isthing": 0, "name": "sewer"},
    {"color": [6, 51, 255], "id": 344, "isthing": 0, "name": "sewing machine"},
    {"color": [235, 12, 255], "id": 345, "isthing": 0, "name": "shed"},
    {"color": [160, 150, 20], "id": 346, "isthing": 0, "name": "sheep"},
    {"color": [0, 163, 255], "id": 347, "isthing": 0, "name": "shell"},
    {"color": [140, 140, 140], "id": 348, "isthing": 0, "name": "shelves"},
    {"color": [250, 10, 15], "id": 349, "isthing": 0, "name": "shoe"},
    {"color": [20, 255, 0], "id": 350, "isthing": 0, "name": "shopping cart"},
    {"color": [31, 255, 0], "id": 351, "isthing": 0, "name": "shovel"},
    {"color": [255, 31, 0], "id": 352, "isthing": 0, "name": "sidecar"},
    {"color": [255, 224, 0], "id": 353, "isthing": 0, "name": "sidewalk"},
    {"color": [153, 255, 0], "id": 354, "isthing": 0, "name": "sign"},
    {"color": [0, 0, 255], "id": 355, "isthing": 0, "name": "signal light"},
    {"color": [255, 71, 0], "id": 356, "isthing": 0, "name": "sink"},
    {"color": [0, 235, 255], "id": 357, "isthing": 0, "name": "skateboard"},
    {"color": [0, 173, 255], "id": 358, "isthing": 0, "name": "ski"},
    {"color": [31, 0, 255], "id": 359, "isthing": 0, "name": "sky"},
    {"color": [120, 120, 120], "id": 360, "isthing": 0, "name": "sled"},
    {"color": [180, 120, 120], "id": 361, "isthing": 0, "name": "slippers"},
    {"color": [6, 230, 230], "id": 362, "isthing": 0, "name": "smoke"},
    {"color": [80, 50, 50], "id": 363, "isthing": 0, "name": "snail"},
    {"color": [4, 200, 3], "id": 364, "isthing": 0, "name": "snake"},
    {"color": [120, 120, 80], "id": 365, "isthing": 0, "name": "snow"},
    {"color": [140, 140, 140], "id": 366, "isthing": 0, "name": "snowmobiles"},
    {"color": [204, 5, 255], "id": 367, "isthing": 0, "name": "sofa"},
    {"color": [230, 230, 230], "id": 368, "isthing": 0, "name": "spanner"},
    {"color": [4, 250, 7], "id": 369, "isthing": 0, "name": "spatula"},
    {"color": [224, 5, 255], "id": 370, "isthing": 0, "name": "speaker"},
    {"color": [235, 255, 7], "id": 371, "isthing": 0, "name": "speed bump"},
    {"color": [150, 5, 61], "id": 372, "isthing": 0, "name": "spice container"},
    {"color": [120, 120, 70], "id": 373, "isthing": 0, "name": "spoon"},
    {"color": [8, 255, 51], "id": 374, "isthing": 0, "name": "sprayer"},
    {"color": [255, 6, 82], "id": 375, "isthing": 0, "name": "squirrel"},
    {"color": [143, 255, 140], "id": 376, "isthing": 0, "name": "stage"},
    {"color": [204, 255, 4], "id": 377, "isthing": 0, "name": "stair"},
    {"color": [255, 51, 7], "id": 378, "isthing": 0, "name": "stapler"},
    {"color": [204, 70, 3], "id": 379, "isthing": 0, "name": "stick"},
    {"color": [0, 102, 200], "id": 380, "isthing": 0, "name": "sticky note"},
    {"color": [61, 230, 250], "id": 381, "isthing": 0, "name": "stone"},
    {"color": [255, 6, 51], "id": 382, "isthing": 0, "name": "stool"},
    {"color": [11, 102, 255], "id": 383, "isthing": 0, "name": "stove"},
    {"color": [255, 7, 71], "id": 384, "isthing": 0, "name": "straw"},
    {"color": [255, 9, 224], "id": 385, "isthing": 0, "name": "stretcher"},
    {"color": [9, 7, 230], "id": 386, "isthing": 0, "name": "sun"},
    {"color": [220, 220, 220], "id": 387, "isthing": 0, "name": "sunglass"},
    {"color": [255, 9, 92], "id": 388, "isthing": 0, "name": "sunshade"},
    {"color": [112, 9, 255], "id": 389, "isthing": 0, "name": "surveillance camera"},
    {"color": [8, 255, 214], "id": 390, "isthing": 0, "name": "swan"},
    {"color": [7, 255, 224], "id": 391, "isthing": 0, "name": "sweeper"},
    {"color": [255, 184, 6], "id": 392, "isthing": 0, "name": "swim ring"},
    {"color": [10, 255, 71], "id": 393, "isthing": 0, "name": "swimming pool"},
    {"color": [255, 41, 10], "id": 394, "isthing": 0, "name": "swing"},
    {"color": [7, 255, 255], "id": 395, "isthing": 0, "name": "switch"},
    {"color": [224, 255, 8], "id": 396, "isthing": 0, "name": "table"},
    {"color": [102, 8, 255], "id": 397, "isthing": 0, "name": "tableware"},
    {"color": [255, 61, 6], "id": 398, "isthing": 0, "name": "tank"},
    {"color": [255, 194, 7], "id": 399, "isthing": 0, "name": "tap"},
    {"color": [255, 122, 8], "id": 400, "isthing": 0, "name": "tape"},
    {"color": [0, 255, 20], "id": 401, "isthing": 0, "name": "tarp"},
    {"color": [255, 8, 41], "id": 402, "isthing": 0, "name": "telephone"},
    {"color": [255, 5, 153], "id": 403, "isthing": 0, "name": "telephone booth"},
    {"color": [6, 51, 255], "id": 404, "isthing": 0, "name": "tent"},
    {"color": [235, 12, 255], "id": 405, "isthing": 0, "name": "tire"},
    {"color": [160, 150, 20], "id": 406, "isthing": 0, "name": "toaster"},
    {"color": [0, 163, 255], "id": 407, "isthing": 0, "name": "toilet"},
    {"color": [140, 140, 140], "id": 408, "isthing": 0, "name": "tong"},
    {"color": [250, 10, 15], "id": 409, "isthing": 0, "name": "tool"},
    {"color": [20, 255, 0], "id": 410, "isthing": 0, "name": "toothbrush"},
    {"color": [31, 255, 0], "id": 411, "isthing": 0, "name": "towel"},
    {"color": [255, 31, 0], "id": 412, "isthing": 0, "name": "toy"},
    {"color": [255, 224, 0], "id": 413, "isthing": 0, "name": "toy car"},
    {"color": [153, 255, 0], "id": 414, "isthing": 0, "name": "track"},
    {"color": [0, 0, 255], "id": 415, "isthing": 0, "name": "train"},
    {"color": [255, 71, 0], "id": 416, "isthing": 0, "name": "trampoline"},
    {"color": [0, 235, 255], "id": 417, "isthing": 0, "name": "trash bin"},
    {"color": [0, 173, 255], "id": 418, "isthing": 0, "name": "tray"},
    {"color": [31, 0, 255], "id": 419, "isthing": 0, "name": "tree"},
    {"color": [120, 120, 120], "id": 420, "isthing": 0, "name": "tricycle"},
    {"color": [180, 120, 120], "id": 421, "isthing": 0, "name": "tripod"},
    {"color": [6, 230, 230], "id": 422, "isthing": 0, "name": "trophy"},
    {"color": [80, 50, 50], "id": 423, "isthing": 0, "name": "truck"},
    {"color": [4, 200, 3], "id": 424, "isthing": 0, "name": "tube"},
    {"color": [120, 120, 80], "id": 425, "isthing": 0, "name": "turtle"},
    {"color": [140, 140, 140], "id": 426, "isthing": 0, "name": "tvmonitor"},
    {"color": [204, 5, 255], "id": 427, "isthing": 0, "name": "tweezers"},
    {"color": [230, 230, 230], "id": 428, "isthing": 0, "name": "typewriter"},
    {"color": [4, 250, 7], "id": 429, "isthing": 0, "name": "umbrella"},
    {"color": [224, 5, 255], "id": 430, "isthing": 0, "name": "unknown"},
    {"color": [235, 255, 7], "id": 431, "isthing": 0, "name": "vacuum cleaner"},
    {"color": [150, 5, 61], "id": 432, "isthing": 0, "name": "vending machine"},
    {"color": [120, 120, 70], "id": 433, "isthing": 0, "name": "video camera"},
    {"color": [8, 255, 51], "id": 434, "isthing": 0, "name": "video game console"},
    {"color": [255, 6, 82], "id": 435, "isthing": 0, "name": "video player"},
    {"color": [143, 255, 140], "id": 436, "isthing": 0, "name": "video tape"},
    {"color": [204, 255, 4], "id": 437, "isthing": 0, "name": "violin"},
    {"color": [255, 51, 7], "id": 438, "isthing": 0, "name": "wakeboard"},
    {"color": [204, 70, 3], "id": 439, "isthing": 0, "name": "wall"},
    {"color": [0, 102, 200], "id": 440, "isthing": 0, "name": "wallet"},
    {"color": [61, 230, 250], "id": 441, "isthing": 0, "name": "wardrobe"},
    {"color": [255, 6, 51], "id": 442, "isthing": 0, "name": "washing machine"},
    {"color": [11, 102, 255], "id": 443, "isthing": 0, "name": "watch"},
    {"color": [255, 7, 71], "id": 444, "isthing": 0, "name": "water"},
    {"color": [255, 9, 224], "id": 445, "isthing": 0, "name": "water dispenser"},
    {"color": [9, 7, 230], "id": 446, "isthing": 0, "name": "water pipe"},
    {"color": [220, 220, 220], "id": 447, "isthing": 0, "name": "water skate board"},
    {"color": [255, 9, 92], "id": 448, "isthing": 0, "name": "watermelon"},
    {"color": [112, 9, 255], "id": 449, "isthing": 0, "name": "whale"},
    {"color": [8, 255, 214], "id": 450, "isthing": 0, "name": "wharf"},
    {"color": [7, 255, 224], "id": 451, "isthing": 0, "name": "wheel"},
    {"color": [255, 184, 6], "id": 452, "isthing": 0, "name": "wheelchair"},
    {"color": [10, 255, 71], "id": 453, "isthing": 0, "name": "window"},
    {"color": [255, 41, 10], "id": 454, "isthing": 0, "name": "window blinds"},
    {"color": [7, 255, 255], "id": 455, "isthing": 0, "name": "wineglass"},
    {"color": [224, 255, 8], "id": 456, "isthing": 0, "name": "wire"},
    {"color": [102, 8, 255], "id": 457, "isthing": 0, "name": "wood"},
    {"color": [255, 61, 6], "id": 458, "isthing": 0, "name": "wool"},
]

PASCAL_CTX_59_CATEGORIES = [
    {"color": [180, 120, 120], "id": 0, "isthing": 0, "name": "aeroplane"},
    {"color": [6, 230, 230], "id": 1, "isthing": 0, "name": "bag"},
    {"color": [80, 50, 50], "id": 2, "isthing": 0, "name": "bed"},
    {"color": [4, 200, 3], "id": 3, "isthing": 0, "name": "bedclothes"},
    {"color": [120, 120, 80], "id": 4, "isthing": 0, "name": "bench"},
    {"color": [140, 140, 140], "id": 5, "isthing": 0, "name": "bicycle"},
    {"color": [204, 5, 255], "id": 6, "isthing": 0, "name": "bird"},
    {"color": [230, 230, 230], "id": 7, "isthing": 0, "name": "boat"},
    {"color": [4, 250, 7], "id": 8, "isthing": 0, "name": "book"},
    {"color": [224, 5, 255], "id": 9, "isthing": 0, "name": "bottle"},
    {"color": [235, 255, 7], "id": 10, "isthing": 0, "name": "building"},
    {"color": [150, 5, 61], "id": 11, "isthing": 0, "name": "bus"},
    {"color": [120, 120, 70], "id": 12, "isthing": 0, "name": "cabinet"},
    {"color": [8, 255, 51], "id": 13, "isthing": 0, "name": "car"},
    {"color": [255, 6, 82], "id": 14, "isthing": 0, "name": "cat"},
    {"color": [143, 255, 140], "id": 15, "isthing": 0, "name": "ceiling"},
    {"color": [204, 255, 4], "id": 16, "isthing": 0, "name": "chair"},
    {"color": [255, 51, 7], "id": 17, "isthing": 0, "name": "cloth"},
    {"color": [204, 70, 3], "id": 18, "isthing": 0, "name": "computer"},
    {"color": [0, 102, 200], "id": 19, "isthing": 0, "name": "cow"},
    {"color": [61, 230, 250], "id": 20, "isthing": 0, "name": "cup"},
    {"color": [255, 6, 51], "id": 21, "isthing": 0, "name": "curtain"},
    {"color": [11, 102, 255], "id": 22, "isthing": 0, "name": "dog"},
    {"color": [255, 7, 71], "id": 23, "isthing": 0, "name": "door"},
    {"color": [255, 9, 224], "id": 24, "isthing": 0, "name": "fence"},
    {"color": [9, 7, 230], "id": 25, "isthing": 0, "name": "floor"},
    {"color": [220, 220, 220], "id": 26, "isthing": 0, "name": "flower"},
    {"color": [255, 9, 92], "id": 27, "isthing": 0, "name": "food"},
    {"color": [112, 9, 255], "id": 28, "isthing": 0, "name": "grass"},
    {"color": [8, 255, 214], "id": 29, "isthing": 0, "name": "ground"},
    {"color": [7, 255, 224], "id": 30, "isthing": 0, "name": "horse"},
    {"color": [255, 184, 6], "id": 31, "isthing": 0, "name": "keyboard"},
    {"color": [10, 255, 71], "id": 32, "isthing": 0, "name": "light"},
    {"color": [255, 41, 10], "id": 33, "isthing": 0, "name": "motorbike"},
    {"color": [7, 255, 255], "id": 34, "isthing": 0, "name": "mountain"},
    {"color": [224, 255, 8], "id": 35, "isthing": 0, "name": "mouse"},
    {"color": [102, 8, 255], "id": 36, "isthing": 0, "name": "person"},
    {"color": [255, 61, 6], "id": 37, "isthing": 0, "name": "plate"},
    {"color": [255, 194, 7], "id": 38, "isthing": 0, "name": "platform"},
    {"color": [255, 122, 8], "id": 39, "isthing": 0, "name": "pottedplant"},
    {"color": [0, 255, 20], "id": 40, "isthing": 0, "name": "road"},
    {"color": [255, 8, 41], "id": 41, "isthing": 0, "name": "rock"},
    {"color": [255, 5, 153], "id": 42, "isthing": 0, "name": "sheep"},
    {"color": [6, 51, 255], "id": 43, "isthing": 0, "name": "shelves"},
    {"color": [235, 12, 255], "id": 44, "isthing": 0, "name": "sidewalk"},
    {"color": [160, 150, 20], "id": 45, "isthing": 0, "name": "sign"},
    {"color": [0, 163, 255], "id": 46, "isthing": 0, "name": "sky"},
    {"color": [140, 140, 140], "id": 47, "isthing": 0, "name": "snow"},
    {"color": [250, 10, 15], "id": 48, "isthing": 0, "name": "sofa"},
    {"color": [20, 255, 0], "id": 49, "isthing": 0, "name": "diningtable"},
    {"color": [31, 255, 0], "id": 50, "isthing": 0, "name": "track"},
    {"color": [255, 31, 0], "id": 51, "isthing": 0, "name": "train"},
    {"color": [255, 224, 0], "id": 52, "isthing": 0, "name": "tree"},
    {"color": [153, 255, 0], "id": 53, "isthing": 0, "name": "truck"},
    {"color": [0, 0, 255], "id": 54, "isthing": 0, "name": "tvmonitor"},
    {"color": [255, 71, 0], "id": 55, "isthing": 0, "name": "wall"},
    {"color": [0, 235, 255], "id": 56, "isthing": 0, "name": "water"},
    {"color": [0, 173, 255], "id": 57, "isthing": 0, "name": "window"},
    {"color": [31, 0, 255], "id": 58, "isthing": 0, "name": "wood"},
]

MAPILLARY_VISTAS_SEM_SEG_CATEGORIES = [
    {'color': [165, 42, 42],
    'id': 1,
    'isthing': 1,
    'name': 'Bird',
    'supercategory': 'animal--bird'},
    {'color': [0, 192, 0],
    'id': 2,
    'isthing': 1,
    'name': 'Ground Animal',
    'supercategory': 'animal--ground-animal'},
    {'color': [196, 196, 196],
    'id': 3,
    'isthing': 0,
    'name': 'Curb',
    'supercategory': 'construction--barrier--curb'},
    {'color': [190, 153, 153],
    'id': 4,
    'isthing': 0,
    'name': 'Fence',
    'supercategory': 'construction--barrier--fence'},
    {'color': [180, 165, 180],
    'id': 5,
    'isthing': 0,
    'name': 'Guard Rail',
    'supercategory': 'construction--barrier--guard-rail'},
    {'color': [90, 120, 150],
    'id': 6,
    'isthing': 0,
    'name': 'Barrier',
    'supercategory': 'construction--barrier--other-barrier'},
    {'color': [102, 102, 156],
    'id': 7,
    'isthing': 0,
    'name': 'Wall',
    'supercategory': 'construction--barrier--wall'},
    {'color': [128, 64, 255],
    'id': 8,
    'isthing': 0,
    'name': 'Bike Lane',
    'supercategory': 'construction--flat--bike-lane'},
    {'color': [140, 140, 200],
    'id': 9,
    'isthing': 1,
    'name': 'Crosswalk - Plain',
    'supercategory': 'construction--flat--crosswalk-plain'},
    {'color': [170, 170, 170],
    'id': 10,
    'isthing': 0,
    'name': 'Curb Cut',
    'supercategory': 'construction--flat--curb-cut'},
    {'color': [250, 170, 160],
    'id': 11,
    'isthing': 0,
    'name': 'Parking',
    'supercategory': 'construction--flat--parking'},
    {'color': [96, 96, 96],
    'id': 12,
    'isthing': 0,
    'name': 'Pedestrian Area',
    'supercategory': 'construction--flat--pedestrian-area'},
    {'color': [230, 150, 140],
    'id': 13,
    'isthing': 0,
    'name': 'Rail Track',
    'supercategory': 'construction--flat--rail-track'},
    {'color': [128, 64, 128],
    'id': 14,
    'isthing': 0,
    'name': 'Road',
    'supercategory': 'construction--flat--road'},
    {'color': [110, 110, 110],
    'id': 15,
    'isthing': 0,
    'name': 'Service Lane',
    'supercategory': 'construction--flat--service-lane'},
    {'color': [244, 35, 232],
    'id': 16,
    'isthing': 0,
    'name': 'Sidewalk',
    'supercategory': 'construction--flat--sidewalk'},
    {'color': [150, 100, 100],
    'id': 17,
    'isthing': 0,
    'name': 'Bridge',
    'supercategory': 'construction--structure--bridge'},
    {'color': [70, 70, 70],
    'id': 18,
    'isthing': 0,
    'name': 'Building',
    'supercategory': 'construction--structure--building'},
    {'color': [150, 120, 90],
    'id': 19,
    'isthing': 0,
    'name': 'Tunnel',
    'supercategory': 'construction--structure--tunnel'},
    {'color': [220, 20, 60],
    'id': 20,
    'isthing': 1,
    'name': 'Person',
    'supercategory': 'human--person'},
    {'color': [255, 0, 0],
    'id': 21,
    'isthing': 1,
    'name': 'Bicyclist',
    'supercategory': 'human--rider--bicyclist'},
    {'color': [255, 0, 100],
    'id': 22,
    'isthing': 1,
    'name': 'Motorcyclist',
    'supercategory': 'human--rider--motorcyclist'},
    {'color': [255, 0, 200],
    'id': 23,
    'isthing': 1,
    'name': 'Other Rider',
    'supercategory': 'human--rider--other-rider'},
    {'color': [200, 128, 128],
    'id': 24,
    'isthing': 1,
    'name': 'Lane Marking - Crosswalk',
    'supercategory': 'marking--crosswalk-zebra'},
    {'color': [255, 255, 255],
    'id': 25,
    'isthing': 0,
    'name': 'Lane Marking - General',
    'supercategory': 'marking--general'},
    {'color': [64, 170, 64],
    'id': 26,
    'isthing': 0,
    'name': 'Mountain',
    'supercategory': 'nature--mountain'},
    {'color': [230, 160, 50],
    'id': 27,
    'isthing': 0,
    'name': 'Sand',
    'supercategory': 'nature--sand'},
    {'color': [70, 130, 180],
    'id': 28,
    'isthing': 0,
    'name': 'Sky',
    'supercategory': 'nature--sky'},
    {'color': [190, 255, 255],
    'id': 29,
    'isthing': 0,
    'name': 'Snow',
    'supercategory': 'nature--snow'},
    {'color': [152, 251, 152],
    'id': 30,
    'isthing': 0,
    'name': 'Terrain',
    'supercategory': 'nature--terrain'},
    {'color': [107, 142, 35],
    'id': 31,
    'isthing': 0,
    'name': 'Vegetation',
    'supercategory': 'nature--vegetation'},
    {'color': [0, 170, 30],
    'id': 32,
    'isthing': 0,
    'name': 'Water',
    'supercategory': 'nature--water'},
    {'color': [255, 255, 128],
    'id': 33,
    'isthing': 1,
    'name': 'Banner',
    'supercategory': 'object--banner'},
    {'color': [250, 0, 30],
    'id': 34,
    'isthing': 1,
    'name': 'Bench',
    'supercategory': 'object--bench'},
    {'color': [100, 140, 180],
    'id': 35,
    'isthing': 1,
    'name': 'Bike Rack',
    'supercategory': 'object--bike-rack'},
    {'color': [220, 220, 220],
    'id': 36,
    'isthing': 1,
    'name': 'Billboard',
    'supercategory': 'object--billboard'},
    {'color': [220, 128, 128],
    'id': 37,
    'isthing': 1,
    'name': 'Catch Basin',
    'supercategory': 'object--catch-basin'},
    {'color': [222, 40, 40],
    'id': 38,
    'isthing': 1,
    'name': 'CCTV Camera',
    'supercategory': 'object--cctv-camera'},
    {'color': [100, 170, 30],
    'id': 39,
    'isthing': 1,
    'name': 'Fire Hydrant',
    'supercategory': 'object--fire-hydrant'},
    {'color': [40, 40, 40],
    'id': 40,
    'isthing': 1,
    'name': 'Junction Box',
    'supercategory': 'object--junction-box'},
    {'color': [33, 33, 33],
    'id': 41,
    'isthing': 1,
    'name': 'Mailbox',
    'supercategory': 'object--mailbox'},
    {'color': [100, 128, 160],
    'id': 42,
    'isthing': 1,
    'name': 'Manhole',
    'supercategory': 'object--manhole'},
    {'color': [142, 0, 0],
    'id': 43,
    'isthing': 1,
    'name': 'Phone Booth',
    'supercategory': 'object--phone-booth'},
    {'color': [70, 100, 150],
    'id': 44,
    'isthing': 0,
    'name': 'Pothole',
    'supercategory': 'object--pothole'},
    {'color': [210, 170, 100],
    'id': 45,
    'isthing': 1,
    'name': 'Street Light',
    'supercategory': 'object--street-light'},
    {'color': [153, 153, 153],
    'id': 46,
    'isthing': 1,
    'name': 'Pole',
    'supercategory': 'object--support--pole'},
    {'color': [128, 128, 128],
    'id': 47,
    'isthing': 1,
    'name': 'Traffic Sign Frame',
    'supercategory': 'object--support--traffic-sign-frame'},
    {'color': [0, 0, 80],
    'id': 48,
    'isthing': 1,
    'name': 'Utility Pole',
    'supercategory': 'object--support--utility-pole'},
    {'color': [250, 170, 30],
    'id': 49,
    'isthing': 1,
    'name': 'Traffic Light',
    'supercategory': 'object--traffic-light'},
    {'color': [192, 192, 192],
    'id': 50,
    'isthing': 1,
    'name': 'Traffic Sign (Back)',
    'supercategory': 'object--traffic-sign--back'},
    {'color': [220, 220, 0],
    'id': 51,
    'isthing': 1,
    'name': 'Traffic Sign (Front)',
    'supercategory': 'object--traffic-sign--front'},
    {'color': [140, 140, 20],
    'id': 52,
    'isthing': 1,
    'name': 'Trash Can',
    'supercategory': 'object--trash-can'},
    {'color': [119, 11, 32],
    'id': 53,
    'isthing': 1,
    'name': 'Bicycle',
    'supercategory': 'object--vehicle--bicycle'},
    {'color': [150, 0, 255],
    'id': 54,
    'isthing': 1,
    'name': 'Boat',
    'supercategory': 'object--vehicle--boat'},
    {'color': [0, 60, 100],
    'id': 55,
    'isthing': 1,
    'name': 'Bus',
    'supercategory': 'object--vehicle--bus'},
    {'color': [0, 0, 142],
    'id': 56,
    'isthing': 1,
    'name': 'Car',
    'supercategory': 'object--vehicle--car'},
    {'color': [0, 0, 90],
    'id': 57,
    'isthing': 1,
    'name': 'Caravan',
    'supercategory': 'object--vehicle--caravan'},
    {'color': [0, 0, 230],
    'id': 58,
    'isthing': 1,
    'name': 'Motorcycle',
    'supercategory': 'object--vehicle--motorcycle'},
    {'color': [0, 80, 100],
    'id': 59,
    'isthing': 0,
    'name': 'On Rails',
    'supercategory': 'object--vehicle--on-rails'},
    {'color': [128, 64, 64],
    'id': 60,
    'isthing': 1,
    'name': 'Other Vehicle',
    'supercategory': 'object--vehicle--other-vehicle'},
    {'color': [0, 0, 110],
    'id': 61,
    'isthing': 1,
    'name': 'Trailer',
    'supercategory': 'object--vehicle--trailer'},
    {'color': [0, 0, 70],
    'id': 62,
    'isthing': 1,
    'name': 'Truck',
    'supercategory': 'object--vehicle--truck'},
    {'color': [0, 0, 192],
    'id': 63,
    'isthing': 1,
    'name': 'Wheeled Slow',
    'supercategory': 'object--vehicle--wheeled-slow'},
    {'color': [32, 32, 32],
    'id': 64,
    'isthing': 0,
    'name': 'Car Mount',
    'supercategory': 'void--car-mount'},
    {'color': [120, 10, 10],
    'id': 65,
    'isthing': 0,
    'name': 'Ego Vehicle',
    'supercategory': 'void--ego-vehicle'}
]

COCO_STUFF_CATEGORIES = [
    {"color": [220, 20, 60], "isthing": 1, "id": 1, "name": "person"},
    {"color": [119, 11, 32], "isthing": 1, "id": 2, "name": "bicycle"},
    {"color": [0, 0, 142], "isthing": 1, "id": 3, "name": "car"},
    {"color": [0, 0, 230], "isthing": 1, "id": 4, "name": "motorcycle"},
    {"color": [106, 0, 228], "isthing": 1, "id": 5, "name": "airplane"},
    {"color": [0, 60, 100], "isthing": 1, "id": 6, "name": "bus"},
    {"color": [0, 80, 100], "isthing": 1, "id": 7, "name": "train"},
    {"color": [0, 0, 70], "isthing": 1, "id": 8, "name": "truck"},
    {"color": [0, 0, 192], "isthing": 1, "id": 9, "name": "boat"},
    {"color": [250, 170, 30], "isthing": 1, "id": 10, "name": "traffic light"},
    {"color": [100, 170, 30], "isthing": 1, "id": 11, "name": "fire hydrant"},
    {"color": [220, 220, 0], "isthing": 1, "id": 13, "name": "stop sign"},
    {"color": [175, 116, 175], "isthing": 1, "id": 14, "name": "parking meter"},
    {"color": [250, 0, 30], "isthing": 1, "id": 15, "name": "bench"},
    {"color": [165, 42, 42], "isthing": 1, "id": 16, "name": "bird"},
    {"color": [255, 77, 255], "isthing": 1, "id": 17, "name": "cat"},
    {"color": [0, 226, 252], "isthing": 1, "id": 18, "name": "dog"},
    {"color": [182, 182, 255], "isthing": 1, "id": 19, "name": "horse"},
    {"color": [0, 82, 0], "isthing": 1, "id": 20, "name": "sheep"},
    {"color": [120, 166, 157], "isthing": 1, "id": 21, "name": "cow"},
    {"color": [110, 76, 0], "isthing": 1, "id": 22, "name": "elephant"},
    {"color": [174, 57, 255], "isthing": 1, "id": 23, "name": "bear"},
    {"color": [199, 100, 0], "isthing": 1, "id": 24, "name": "zebra"},
    {"color": [72, 0, 118], "isthing": 1, "id": 25, "name": "giraffe"},
    {"color": [255, 179, 240], "isthing": 1, "id": 27, "name": "backpack"},
    {"color": [0, 125, 92], "isthing": 1, "id": 28, "name": "umbrella"},
    {"color": [209, 0, 151], "isthing": 1, "id": 31, "name": "handbag"},
    {"color": [188, 208, 182], "isthing": 1, "id": 32, "name": "tie"},
    {"color": [0, 220, 176], "isthing": 1, "id": 33, "name": "suitcase"},
    {"color": [255, 99, 164], "isthing": 1, "id": 34, "name": "frisbee"},
    {"color": [92, 0, 73], "isthing": 1, "id": 35, "name": "skis"},
    {"color": [133, 129, 255], "isthing": 1, "id": 36, "name": "snowboard"},
    {"color": [78, 180, 255], "isthing": 1, "id": 37, "name": "sports ball"},
    {"color": [0, 228, 0], "isthing": 1, "id": 38, "name": "kite"},
    {"color": [174, 255, 243], "isthing": 1, "id": 39, "name": "baseball bat"},
    {"color": [45, 89, 255], "isthing": 1, "id": 40, "name": "baseball glove"},
    {"color": [134, 134, 103], "isthing": 1, "id": 41, "name": "skateboard"},
    {"color": [145, 148, 174], "isthing": 1, "id": 42, "name": "surfboard"},
    {"color": [255, 208, 186], "isthing": 1, "id": 43, "name": "tennis racket"},
    {"color": [197, 226, 255], "isthing": 1, "id": 44, "name": "bottle"},
    {"color": [171, 134, 1], "isthing": 1, "id": 46, "name": "wine glass"},
    {"color": [109, 63, 54], "isthing": 1, "id": 47, "name": "cup"},
    {"color": [207, 138, 255], "isthing": 1, "id": 48, "name": "fork"},
    {"color": [151, 0, 95], "isthing": 1, "id": 49, "name": "knife"},
    {"color": [9, 80, 61], "isthing": 1, "id": 50, "name": "spoon"},
    {"color": [84, 105, 51], "isthing": 1, "id": 51, "name": "bowl"},
    {"color": [74, 65, 105], "isthing": 1, "id": 52, "name": "banana"},
    {"color": [166, 196, 102], "isthing": 1, "id": 53, "name": "apple"},
    {"color": [208, 195, 210], "isthing": 1, "id": 54, "name": "sandwich"},
    {"color": [255, 109, 65], "isthing": 1, "id": 55, "name": "orange"},
    {"color": [0, 143, 149], "isthing": 1, "id": 56, "name": "broccoli"},
    {"color": [179, 0, 194], "isthing": 1, "id": 57, "name": "carrot"},
    {"color": [209, 99, 106], "isthing": 1, "id": 58, "name": "hot dog"},
    {"color": [5, 121, 0], "isthing": 1, "id": 59, "name": "pizza"},
    {"color": [227, 255, 205], "isthing": 1, "id": 60, "name": "donut"},
    {"color": [147, 186, 208], "isthing": 1, "id": 61, "name": "cake"},
    {"color": [153, 69, 1], "isthing": 1, "id": 62, "name": "chair"},
    {"color": [3, 95, 161], "isthing": 1, "id": 63, "name": "couch"},
    {"color": [163, 255, 0], "isthing": 1, "id": 64, "name": "potted plant"},
    {"color": [119, 0, 170], "isthing": 1, "id": 65, "name": "bed"},
    {"color": [0, 182, 199], "isthing": 1, "id": 67, "name": "dining table"},
    {"color": [0, 165, 120], "isthing": 1, "id": 70, "name": "toilet"},
    {"color": [183, 130, 88], "isthing": 1, "id": 72, "name": "tv"},
    {"color": [95, 32, 0], "isthing": 1, "id": 73, "name": "laptop"},
    {"color": [130, 114, 135], "isthing": 1, "id": 74, "name": "mouse"},
    {"color": [110, 129, 133], "isthing": 1, "id": 75, "name": "remote"},
    {"color": [166, 74, 118], "isthing": 1, "id": 76, "name": "keyboard"},
    {"color": [219, 142, 185], "isthing": 1, "id": 77, "name": "cell phone"},
    {"color": [79, 210, 114], "isthing": 1, "id": 78, "name": "microwave"},
    {"color": [178, 90, 62], "isthing": 1, "id": 79, "name": "oven"},
    {"color": [65, 70, 15], "isthing": 1, "id": 80, "name": "toaster"},
    {"color": [127, 167, 115], "isthing": 1, "id": 81, "name": "sink"},
    {"color": [59, 105, 106], "isthing": 1, "id": 82, "name": "refrigerator"},
    {"color": [142, 108, 45], "isthing": 1, "id": 84, "name": "book"},
    {"color": [196, 172, 0], "isthing": 1, "id": 85, "name": "clock"},
    {"color": [95, 54, 80], "isthing": 1, "id": 86, "name": "vase"},
    {"color": [128, 76, 255], "isthing": 1, "id": 87, "name": "scissors"},
    {"color": [201, 57, 1], "isthing": 1, "id": 88, "name": "teddy bear"},
    {"color": [246, 0, 122], "isthing": 1, "id": 89, "name": "hair drier"},
    {"color": [191, 162, 208], "isthing": 1, "id": 90, "name": "toothbrush"},
    {"id": 92, "name": "banner", "supercategory": "textile"},
    {"id": 93, "name": "blanket", "supercategory": "textile"},
    {"id": 94, "name": "branch", "supercategory": "plant"},
    {"id": 95, "name": "bridge", "supercategory": "building"},
    {"id": 96, "name": "building-other", "supercategory": "building"},
    {"id": 97, "name": "bush", "supercategory": "plant"},
    {"id": 98, "name": "cabinet", "supercategory": "furniture-stuff"},
    {"id": 99, "name": "cage", "supercategory": "structural"},
    {"id": 100, "name": "cardboard", "supercategory": "raw-material"},
    {"id": 101, "name": "carpet", "supercategory": "floor"},
    {"id": 102, "name": "ceiling-other", "supercategory": "ceiling"},
    {"id": 103, "name": "ceiling-tile", "supercategory": "ceiling"},
    {"id": 104, "name": "cloth", "supercategory": "textile"},
    {"id": 105, "name": "clothes", "supercategory": "textile"},
    {"id": 106, "name": "clouds", "supercategory": "sky"},
    {"id": 107, "name": "counter", "supercategory": "furniture-stuff"},
    {"id": 108, "name": "cupboard", "supercategory": "furniture-stuff"},
    {"id": 109, "name": "curtain", "supercategory": "textile"},
    {"id": 110, "name": "desk-stuff", "supercategory": "furniture-stuff"},
    {"id": 111, "name": "dirt", "supercategory": "ground"},
    {"id": 112, "name": "door-stuff", "supercategory": "furniture-stuff"},
    {"id": 113, "name": "fence", "supercategory": "structural"},
    {"id": 114, "name": "floor-marble", "supercategory": "floor"},
    {"id": 115, "name": "floor-other", "supercategory": "floor"},
    {"id": 116, "name": "floor-stone", "supercategory": "floor"},
    {"id": 117, "name": "floor-tile", "supercategory": "floor"},
    {"id": 118, "name": "floor-wood", "supercategory": "floor"},
    {"id": 119, "name": "flower", "supercategory": "plant"},
    {"id": 120, "name": "fog", "supercategory": "water"},
    {"id": 121, "name": "food-other", "supercategory": "food-stuff"},
    {"id": 122, "name": "fruit", "supercategory": "food-stuff"},
    {"id": 123, "name": "furniture-other", "supercategory": "furniture-stuff"},
    {"id": 124, "name": "grass", "supercategory": "plant"},
    {"id": 125, "name": "gravel", "supercategory": "ground"},
    {"id": 126, "name": "ground-other", "supercategory": "ground"},
    {"id": 127, "name": "hill", "supercategory": "solid"},
    {"id": 128, "name": "house", "supercategory": "building"},
    {"id": 129, "name": "leaves", "supercategory": "plant"},
    {"id": 130, "name": "light", "supercategory": "furniture-stuff"},
    {"id": 131, "name": "mat", "supercategory": "textile"},
    {"id": 132, "name": "metal", "supercategory": "raw-material"},
    {"id": 133, "name": "mirror-stuff", "supercategory": "furniture-stuff"},
    {"id": 134, "name": "moss", "supercategory": "plant"},
    {"id": 135, "name": "mountain", "supercategory": "solid"},
    {"id": 136, "name": "mud", "supercategory": "ground"},
    {"id": 137, "name": "napkin", "supercategory": "textile"},
    {"id": 138, "name": "net", "supercategory": "structural"},
    {"id": 139, "name": "paper", "supercategory": "raw-material"},
    {"id": 140, "name": "pavement", "supercategory": "ground"},
    {"id": 141, "name": "pillow", "supercategory": "textile"},
    {"id": 142, "name": "plant-other", "supercategory": "plant"},
    {"id": 143, "name": "plastic", "supercategory": "raw-material"},
    {"id": 144, "name": "platform", "supercategory": "ground"},
    {"id": 145, "name": "playingfield", "supercategory": "ground"},
    {"id": 146, "name": "railing", "supercategory": "structural"},
    {"id": 147, "name": "railroad", "supercategory": "ground"},
    {"id": 148, "name": "river", "supercategory": "water"},
    {"id": 149, "name": "road", "supercategory": "ground"},
    {"id": 150, "name": "rock", "supercategory": "solid"},
    {"id": 151, "name": "roof", "supercategory": "building"},
    {"id": 152, "name": "rug", "supercategory": "textile"},
    {"id": 153, "name": "salad", "supercategory": "food-stuff"},
    {"id": 154, "name": "sand", "supercategory": "ground"},
    {"id": 155, "name": "sea", "supercategory": "water"},
    {"id": 156, "name": "shelf", "supercategory": "furniture-stuff"},
    {"id": 157, "name": "sky-other", "supercategory": "sky"},
    {"id": 158, "name": "skyscraper", "supercategory": "building"},
    {"id": 159, "name": "snow", "supercategory": "ground"},
    {"id": 160, "name": "solid-other", "supercategory": "solid"},
    {"id": 161, "name": "stairs", "supercategory": "furniture-stuff"},
    {"id": 162, "name": "stone", "supercategory": "solid"},
    {"id": 163, "name": "straw", "supercategory": "plant"},
    {"id": 164, "name": "structural-other", "supercategory": "structural"},
    {"id": 165, "name": "table", "supercategory": "furniture-stuff"},
    {"id": 166, "name": "tent", "supercategory": "building"},
    {"id": 167, "name": "textile-other", "supercategory": "textile"},
    {"id": 168, "name": "towel", "supercategory": "textile"},
    {"id": 169, "name": "tree", "supercategory": "plant"},
    {"id": 170, "name": "vegetable", "supercategory": "food-stuff"},
    {"id": 171, "name": "wall-brick", "supercategory": "wall"},
    {"id": 172, "name": "wall-concrete", "supercategory": "wall"},
    {"id": 173, "name": "wall-other", "supercategory": "wall"},
    {"id": 174, "name": "wall-panel", "supercategory": "wall"},
    {"id": 175, "name": "wall-stone", "supercategory": "wall"},
    {"id": 176, "name": "wall-tile", "supercategory": "wall"},
    {"id": 177, "name": "wall-wood", "supercategory": "wall"},
    {"id": 178, "name": "water-other", "supercategory": "water"},
    {"id": 179, "name": "waterdrops", "supercategory": "water"},
    {"id": 180, "name": "window-blind", "supercategory": "window"},
    {"id": 181, "name": "window-other", "supercategory": "window"},
    {"id": 182, "name": "wood", "supercategory": "solid"},
]

BDD100K_CATEGORIES = [
    {"id": 1, "name": "dynamic", "isthing": 0, "color": [111, 74, 0]},
    {"id": 2, "name": "ego vehicle", "isthing": 0, "color": [81, 0, 81]},
    {"id": 3, "name": "ground", "isthing": 0, "color": [128, 64, 128]},
    {"id": 4, "name": "static", "isthing": 0, "color": [244, 35, 232]},
    {"id": 5, "name": "parking", "isthing": 0, "color": [250, 170, 160]},
    {"id": 6, "name": "rail track", "isthing": 0, "color": [230, 150, 140]},
    {"id": 7, "name": "road", "isthing": 0, "color": [70, 70, 70]},
    {"id": 8, "name": "sidewalk", "isthing": 0, "color": [102, 102, 156]},
    {"id": 9, "name": "bridge", "isthing": 0, "color": [190, 153, 153]},
    {"id": 10, "name": "building", "isthing": 0, "color": [153, 153, 153]},
    {"id": 11, "name": "fence", "isthing": 0, "color": [250, 170, 30]},
    {"id": 12, "name": "garage", "isthing": 0, "color": [220, 220, 0]},
    {"id": 13, "name": "guard rail", "isthing": 0, "color": [107, 142, 35]},
    {"id": 14, "name": "tunnel", "isthing": 0, "color": [152, 251, 152]},
    {"id": 15, "name": "wall", "isthing": 0, "color": [70, 130, 180]},
    {"id": 16, "name": "banner", "isthing": 0, "color": [220, 20, 60]},
    {"id": 17, "name": "billboard", "isthing": 0, "color": [255, 0, 0]},
    {"id": 18, "name": "lane divider", "isthing": 0, "color": [0, 0, 142]},
    {"id": 19, "name": "parking sign", "isthing": 0, "color": [0, 0, 230]},
    {"id": 20, "name": "pole", "isthing": 0, "color": [106, 0, 228]},
    {"id": 21, "name": "polegroup", "isthing": 0, "color": [0, 60, 100]},
    {"id": 22, "name": "street light", "isthing": 0, "color": [0, 80, 100]},
    {"id": 23, "name": "traffic cone", "isthing": 0, "color": [0, 0, 70]},
    {"id": 24, "name": "traffic device", "isthing": 0, "color": [0, 0, 192]},
    {"id": 25, "name": "traffic light", "isthing": 0, "color": [250, 170, 30]},
    {"id": 26, "name": "traffic sign", "isthing": 0, "color": [100, 170, 30]},
    {"id": 27, "name": "traffic sign frame", "isthing": 0, "color": [220, 220, 0]},
    {"id": 28, "name": "terrain", "isthing": 0, "color": [175, 116, 175]},
    {"id": 29, "name": "vegetation", "isthing": 0, "color": [250, 0, 30]},
    {"id": 30, "name": "sky", "isthing": 0, "color": [165, 42, 42]},
    {"id": 31, "name": "person", "isthing": 1, "color": [255, 77, 255]},
    {"id": 32, "name": "rider", "isthing": 1, "color": [0, 226, 252]},
    {"id": 33, "name": "bicycle", "isthing": 1, "color": [182, 182, 255]},
    {"id": 34, "name": "bus", "isthing": 1, "color": [0, 82, 0]},
    {"id": 35, "name": "car", "isthing": 1, "color": [120, 166, 157]},
    {"id": 36, "name": "caravan", "isthing": 1, "color": [110, 76, 0]},
    {"id": 37, "name": "motorcycle", "isthing": 1, "color": [174, 57, 255]},
    {"id": 38, "name": "trailer", "isthing": 1, "color": [199, 100, 0]},
    {"id": 39, "name": "train", "isthing": 1, "color": [72, 0, 118]},
    {"id": 40, "name": "truck", "isthing": 1, "color": [255, 179, 240]},
]


def get_coco_categories_with_prompt_eng():
    COCO_CATEGORIES_ = copy.deepcopy(COCO_CATEGORIES)
    coco_id_names = open('./fcclip/data/datasets/coco_panoptic_with_prompt_eng.txt').read().splitlines()
    coco_idx = 0
    for line in coco_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        #print(COCO_CATEGORIES_[coco_idx]["name"], '->', name)
        assert COCO_CATEGORIES_[coco_idx]["id"] == idx
        COCO_CATEGORIES_[coco_idx]["name"] = name
        coco_idx += 1
    return COCO_CATEGORIES_


def get_coco_stuff_categories_with_prompt_eng():
    COCO_STUFF_CATEGORIES_ = copy.deepcopy(COCO_STUFF_CATEGORIES)
    coco_id_names = open('./fcclip/data/datasets/coco_stuff_with_prompt_eng.txt').read().splitlines()
    coco_idx = 0
    for line in coco_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        #print(COCO_STUFF_CATEGORIES_[coco_idx]["name"], '->', name)
        assert COCO_STUFF_CATEGORIES_[coco_idx]["id"] == idx
        COCO_STUFF_CATEGORIES_[coco_idx]["name"] = name
        coco_idx += 1
    return COCO_STUFF_CATEGORIES_


def get_ade20k_categories_with_prompt_eng():
    ADE20K_150_CATEGORIES_ = copy.deepcopy(ADE20K_150_CATEGORIES)
    ade20k_id_names = open('./fcclip/data/datasets/ade20k_150_with_prompt_eng.txt').read().splitlines()
    ade_idx = 0
    for line in ade20k_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        #print(ADE20K_150_CATEGORIES_[ade_idx]["name"], '->', name)
        assert ADE20K_150_CATEGORIES_[ade_idx]["id"] == idx - 1
        ADE20K_150_CATEGORIES_[ade_idx]["name"] = name
        ade_idx += 1
    return ADE20K_150_CATEGORIES_


def get_cityscapes_categories_with_prompt_eng():
    CITYSCAPES_CATEGORIES_ = copy.deepcopy(CITYSCAPES_CATEGORIES)
    cityscapes_id_names = open('./fcclip/data/datasets/cityscapes_with_prompt_eng.txt').read().splitlines()
    cityscapes_idx = 0
    for line in cityscapes_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if name == "invalid_class_id":
            continue
        #print(CITYSCAPES_CATEGORIES_[cityscapes_idx]["name"], '->', name)
        assert CITYSCAPES_CATEGORIES_[cityscapes_idx]["trainId"] == idx
        CITYSCAPES_CATEGORIES_[cityscapes_idx]["name"] = name
        cityscapes_idx += 1
    return CITYSCAPES_CATEGORIES_, CITYSCAPES_CATEGORIES

def get_ade20k_847_categories_with_prompt_eng():
    ADE20K_847_CATEGORIES_ = copy.deepcopy(ADE20K_847_CATEGORIES)
    ade20k_847_id_names = open('./fcclip/data/datasets/ade20k_847_with_prompt_eng.txt').read().splitlines()
    ade_idx = 0
    for line in ade20k_847_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        #print(ADE20K_847_CATEGORIES_[ade_idx]["name"], '->', name)
        # assert ADE20K_847_CATEGORIES_[ade_idx]["id"] == idx - 1
        ADE20K_847_CATEGORIES_[ade_idx]["name"] = name
        ade_idx += 1
    return ADE20K_847_CATEGORIES_

def get_pascal_21_categories_with_prompt_eng():
    PASCAL_VOC_21_CATEGORIES_ = copy.deepcopy(PASCAL_VOC_21_CATEGORIES)
    pascal_21_id_names = open('./fcclip/data/datasets/pascal_voc_21_with_prompt_eng.txt').read().splitlines()
    pas_idx = 0
    for line in pascal_21_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        PASCAL_VOC_21_CATEGORIES_[pas_idx]["name"] = name
        pas_idx += 1
    return PASCAL_VOC_21_CATEGORIES_

def get_pascal_ctx_459_categories_with_prompt_eng():
    PASCAL_CTX_459_CATEGORIES_ = copy.deepcopy(PASCAL_CTX_459_CATEGORIES)
    pascal_ctx_459_id_names = open('./fcclip/data/datasets/pascal_ctx_459_with_prompt_eng.txt').read().splitlines()
    pas_idx = 0
    for line in pascal_ctx_459_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        PASCAL_CTX_459_CATEGORIES_[pas_idx]["name"] = name
        pas_idx += 1
    return PASCAL_CTX_459_CATEGORIES_

def get_pascal_ctx_59_categories_with_prompt_eng():
    PASCAL_CTX_59_CATEGORIES_ = copy.deepcopy(PASCAL_CTX_59_CATEGORIES)
    pascal_ctx_59_id_names = open('./fcclip/data/datasets/pascal_ctx_59_with_prompt_eng.txt').read().splitlines()
    pas_idx = 0
    for line in pascal_ctx_59_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        PASCAL_CTX_59_CATEGORIES_[pas_idx]["name"] = name
        pas_idx += 1
    return PASCAL_CTX_59_CATEGORIES_

def get_mapillary_vistas_categories_with_prompt_eng():
    MAPILLARY_VISTAS_SEM_SEG_CATEGORIES_ = copy.deepcopy(MAPILLARY_VISTAS_SEM_SEG_CATEGORIES)
    mapillary_vistas_id_names = open('./fcclip/data/datasets/mapillary_vistas_with_prompt_eng.txt').read().splitlines()
    mapillary_idx = 0
    for line in mapillary_vistas_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        MAPILLARY_VISTAS_SEM_SEG_CATEGORIES_[mapillary_idx]["name"] = name
        mapillary_idx += 1
    return MAPILLARY_VISTAS_SEM_SEG_CATEGORIES_

def get_lvis_v1_categories_with_prompt_eng():
    LVIS_CATEGORIES_ = copy.deepcopy(LVIS_CATEGORIES)
    lvis_id_names = open('./fcclip/data/datasets/lvis_1203_with_prompt_eng.txt').read().splitlines()
    lvis_idx = 0
    for line in lvis_id_names:
        idx, name = line.split(':')
        idx = int(idx)
        if idx == 0 or name == "invalid_class_id":
            continue
        #print(COCO_CATEGORIES_[coco_idx]["name"], '->', name)
        assert LVIS_CATEGORIES_[lvis_idx]["id"] == idx
        LVIS_CATEGORIES_[lvis_idx]["name"] = name
        lvis_idx += 1
    return LVIS_CATEGORIES_

if __name__ == "__main__":
    get_coco_categories_with_prompt_eng()
    get_ade20k_categories_with_prompt_eng()
    get_cityscapes_categories_with_prompt_eng()
    get_ade20k_847_categories_with_prompt_eng()
    get_pascal_21_categories_with_prompt_eng()
    get_pascal_ctx_459_categories_with_prompt_eng()
    get_pascal_ctx_59_categories_with_prompt_eng()
    get_mapillary_vistas_categories_with_prompt_eng()
    get_coco_stuff_categories_with_prompt_eng()