# 🚧 Automation (BETA) 

⚠️ **This folder contains BETA features for quick PI-LLM preview and analysis.**

## Purpose
The automation folder provides convenience scripts for users who want:
- Quick proactive interference plots and visualizations
- Automated working memory analysis workflows  
- Combined PI evaluation + plotting in one command

## Beta Status
- ✅ Functional for preview purposes
- ⚠️ Not the code used in the published paper
- 🔧 Subject to changes and improvements
- 📊 Suitable for quick testing and exploration

## Files in this folder:
- `run_full_pipeline.py` - Full automation pipeline (core + plots)
- `analyze_pi_custom.py` - Custom analysis tools
- `analyze_pi_flow_final.py` - Advanced analysis workflows
- `plot_accuracy_trend.py` - Plotting and visualization
- `config_utils.py` - Configuration utilities

## When to use:
- You want quick plots without writing your own analysis code
- You need a preview of results with minimal setup
- You want to explore the benchmark capabilities quickly

## When NOT to use:
- For publication-ready results (use `core/` instead)
- For critical research work requiring maximum stability
- When you need the exact setup used in the paper

---
**For stable, paper-ready code, use the `core/` folder instead.** 