# 🎯 Core - Stable Research Code

✅ **This folder contains the stable PI-LLM implementation used in the published paper.**

## Purpose
The core folder provides the exact implementation used for:
- Proactive interference evaluation in LLMs
- Working memory capacity assessment beyond context length
- Published research results on interference patterns

## Production Status
- ✅ Used in actual research publication
- ✅ Thoroughly tested and validated
- ✅ Stable API and consistent results
- 📄 Reference implementation for citations

## Files in this folder:
- `run_pi.py` - Main test execution engine (the core of the benchmark)
- `pi_flow_upgrade.py` - Updated PI flow implementation
- `chat_terminal.py` - Terminal interface for model testing
- `analysis_helper.py` - Core analysis utilities and functions

## When to use:
- For publication-ready results
- When reproducing paper results exactly
- For critical research work requiring maximum reliability
- When building upon the published methodology

## How to use with core only:
See the main README.md for detailed instructions on running tests 1-5 with different accuracy levels using just the core code.

---
**This is the reference implementation used in our research paper.** 