#### Models
This repository implements several approaches for generating Introduction sections, including:
- Pure Prompt: A baseline using prompt engineering without outline guidance.
- Elaborate Prompt: A structured method enforcing a four-paragraph format.
- Outline Writing: A two-stage process generating outlines followed by content expansion.
- AutoSurvey: An advanced outline-based method with survey-style prompting.
- Stage Writing: A base model utilizing stage-based generation.
- Stage Writing FT: The fine-tuned version of Stage Writing.
- STIG: The proposed Stage Token for Introduction Generation model, integrating stage tokens for end-to-end generation.

#### Execution

##### STIG
Run the STIG model with:
```
python STIG.py
```

##### Pure Prompt and Elaborate Prompt
Execute with the specified generation type:
```
python prompt.py --generate_type pure
```

##### Outline Writing
Run the two-stage outline and content generation:
```
python outline_write.py
```

##### AutoSurvey
Perform the survey-style outline generation:
```
python IntroductionOutline.py
```

##### Stage Writing
Run the base stage-based generation:
```
python StageWriting.py --generate_type base
```

##### Stage Writing FT
Run the fine-tuned stage-based generation:
```
python StageWriting.py --generate_type ft
```

#### Evaluation

##### BERTScore
Compute semantic similarity using BERTScore:
```
python evaluate_bertscore.py --generate_path ../writing_agents_results/base/
```

##### Structural Rationality
Assess subsection alignment for STIG, Stage Writing, and Stage Writing FT:
```
python evaluate_structure.py --generate_type base
```
For Pure Prompt, Elaborate Prompt, and Outline Writing, evaluate with:
```
python evaluate_structure_all.py --generate_type pure_prompt --gen_path path/to/json/storing/pure_prompt_results
python evaluate_structure_all.py --generate_type elaborate --gen_path path/to/json/storing/elaborate_prompt_results
python evaluate_structure_all.py --generate_type outline_write --gen_path path/to/json/storing/outline_writing_results
```

##### Content Coverage
Evaluate key content capture:
```
python evaluate_cover_sections.py --generate_type xx
```

##### PPL
```
python perplexity.py --generate_type xx
```