import sys
sys.path.append('.')

import numpy as np

from online_problem import OnlineProblem  
from solver.online_gradient_descent import OnlineGradientDescent
from lib.function import oper_scal
import config



n=config.n
T=config.T
block=config.block
foldname = config.foldname
SPD =config.SPD


A = np.load(foldname + 'data_A.npy')
X_0 = config.X_0

os_problem = OnlineProblem(     mfd = SPD,
                                data = A,
                                time = T,
                                loss = oper_scal.func,
                                grad = oper_scal.grad,
                                diameter = config.diameter,
                                lipschitz= config.lipschiz,
                                curvature= config.curvature,
                                bound = config.bound
                                ) 

solver = OnlineGradientDescent()
solver.optimize(os_problem,X_0)
solver.calculate_aver_value()
solver.sum_time()
np.save( foldname+ 'data_gradient',solver.aver_value_histories)
np.save( foldname + 'time_gradient',solver.time_sum)
print('gradient solver completed')