import numpy as np
import sys
import os
sys.path.append(os.getcwd())
# dim,rounds and blocks
n=100
T=1000
block=10

# manifold 
from pymanopt.manifolds import PositiveDefinite
SPD = PositiveDefinite(n, k=1)
SPD.center = np.eye(n)

diameter = 1
lipschitz = 2 * diameter / block
bound = (diameter+1) ** 2 / (2*block)
curvature = n
grid_len = 20 
np.random.seed(42)
X_0 = SPD.rand()
X_0 = SPD.exp( SPD.center , diameter * SPD.log(SPD.center,X_0)/SPD.dist(SPD.center,X_0)  )


foldname = os.path.dirname(__file__) + ('/data/dim_{}/').format(n)
