import sys
sys.path.append('.')
import numpy as np
from online_problem import OnlineProblem 
from solver.online_zeroth import OnlineZeroth
from solver.online_bandit import OnlineBandit
from lib.function import frechet_mean_h
import config

n=config.n
T=config.T
block=config.block
foldname = config.foldname
Hn =config.Hn


A = np.load(foldname + 'data_A.npy')
X_0 = config.X_0

os_problem = OnlineProblem(     mfd = Hn,
                                data = A,
                                time = T,
                                loss = frechet_mean_h.func,
                                grad = frechet_mean_h.grad,
                                diameter = config.diameter,
                                lipschitz= config.lipschitz,
                                curvature= config.curvature,
                                bound = config.bound,
                                mu = 0,
                                _sum_f = frechet_mean_h.sum_f,    
                                _sum_grad = frechet_mean_h.sum_grad
                                ) 



solver = OnlineZeroth()
aver_values = np.zeros(  T   )
aver_time = np.zeros(  T  )
rounds = 100
for i in range(rounds):
    solver.optimize(os_problem, X_0)
    solver.calculate_aver_value()
    solver.sum_time()
    aver_values += solver.aver_value_histories
    aver_time   += solver.time_sum
aver_values = aver_values / rounds
aver_time = aver_time /rounds
np.save( foldname + 'data_ozo',aver_values)
np.save( foldname + 'time_ozo',aver_time)
print('zeroth solver completed')
