import sys
import os
sys.path.append(os.getcwd())
import numpy as np

from online_problem import OnlineProblem  
from solver.online_gradient_descent import OnlineGradientDescent
from lib.function import frechet_mean
import config

n=config.n
T=config.T
block=config.block
foldname = config.foldname
SPD =config.SPD


A = np.load(foldname + 'data_A.npy')
X_0 = config.X_0

os_problem = OnlineProblem(     mfd = SPD,
                                data = A,
                                time = T,
                                loss = frechet_mean.func,
                                grad = frechet_mean.grad,
                                diameter = config.diameter,
                                lipschitz= config.lipschitz,
                                curvature= config.curvature,
                                bound = config.bound,
                                mu = 2,
                                _sum_f = frechet_mean.sum_f,
                                _sum_grad = frechet_mean.sum_grad
                                )  

solver = OnlineGradientDescent()
solver.optimize(os_problem,X_0)
solver.calculate_aver_value()
solver.sum_time()

np.save( foldname + 'time_gradient',solver.time_sum)
np.save( foldname+ 'data_gradient_c',solver.aver_value_histories)
print('gradient solver completed')