import numpy as np
import sys
import os
sys.path.append(os.getcwd())
# dim,rounds and blocks
n=101
T=10000
block=10

# manifold 
from manifold.hyperbolic import HyperbolicSpace
Hn = HyperbolicSpace(n)
Hn.center = np.array([0]*(n-1)+[1])

diameter = 5
lipschitz = 2 * diameter / block
bound = (diameter + 1) ** 2 / (block)
curvature = 1
grid_len = 20
np.random.seed(42)
X_0 = Hn.rand()
X_0 = Hn.exp( Hn.center , diameter * Hn.log(Hn.center,X_0)/Hn.dist(Hn.center,X_0)  )
np.random.seed()

foldname = os.path.dirname(__file__) + ('/data/dim_{}_curv_{}/').format(n-1,1)