from pymanopt import manifolds
from manifold.hyperbolic import HyperbolicSpace
from pymanopt.manifolds import *
from .uniformly_choose_funcs import *
from lib.operation import uniformly_choose_funcs
def uniformly_choose(manifold, X , delta):
    if isinstance(manifold, PositiveDefinite):
        return uniformly_choose_SPD(X , delta , X.shape[0])
    elif isinstance(manifold, HyperbolicSpace):
        return uniformly_choose_hyp(manifold, X ,delta)
    else:
        return manifold.randvec(X) * delta
