import sys
sys.path.append('.')

from lib.operation.calculate_regret import CalcuRegret
from lib.operation.plotfigure import gridplot,grid_time_plot
import matplotlib.pyplot as plt
import numpy as np
import config

foldname = config.foldname

gradient_sc_aver_value = np.load(foldname + 'data_gradient_sc.npy')
gradient_c_aver_value = np.load(foldname + 'data_gradient_c.npy')

gradient_time_sc = np.load(foldname + 'time_gradient_sc.npy')
gradient_time_c = np.load(foldname + 'time_gradient_c.npy')

offline_value = np.load(foldname + 'data_offline.npy')
list_T = np.load(foldname + 'list_T.npy')

regret_gradient_sc=CalcuRegret(gradient_sc_aver_value,offline_value,list_T)
regret_gradient_c=CalcuRegret(gradient_c_aver_value,offline_value,list_T)



grid_time_plot(gradient_time_sc,regret_gradient_sc,list_T,label='R-OGD-SC')
grid_time_plot(gradient_time_sc,regret_gradient_sc,list_T,label='R-OGD-C')
plt.legend(prop={'size':16})
plt.xlabel('Ruuning times',fontdict={'size':18})
plt.ylabel('E[Reg(t)] / t',fontdict={'size':18})
plt.xticks(size=14)
plt.yticks(size=14)
plt.gcf().set_facecolor(np.ones(3))
plt.grid(True)
plt.show()


gridplot(regret_gradient_sc,list_T,label='R-OGD-SC')
gridplot(regret_gradient_c,list_T,label='R-OGD-C')
plt.legend(prop={'size':16})
plt.xlabel('Learning rounds t',fontdict={'size':18})
plt.ylabel('E[Reg(t)] / t',fontdict={'size':18})
plt.xticks(size=14)
plt.yticks(size=14)
plt.gcf().set_facecolor(np.ones(3))
plt.grid(True)
plt.show()
