import os
import sys
sys.path.append(os.getcwd())

import numpy as np
from lib.function import frechet_mean_h
from online_problem import OnlineProblem
from solver.online_gradient_descent import OnlineGradientDescent

import config

n=config.n
T=config.T
block=config.block
foldname = config.foldname
Hn =config.Hn


A = np.load(foldname + 'data_A.npy')
X_0 = config.X_0

ol_problem = OnlineProblem(     mfd = Hn,
                                data = A,
                                time = T,
                                loss = frechet_mean_h.func,
                                grad = frechet_mean_h.grad,
                                diameter = config.diameter,
                                lipschitz= config.lipschitz,
                                curvature= config.n,
                                bound = config.bound,
                                mu = 2,
                                _sum_f = frechet_mean_h.sum_f,
                                _sum_grad = frechet_mean_h.sum_grad
                                ) 

solver = OnlineGradientDescent()
solver.optimize(ol_problem,X_0)
solver.calculate_aver_value()
solver.sum_time()

np.save( foldname + 'time_gradient',solver.time_sum)
np.save( foldname+ 'data_gradient_sc',solver.aver_value_histories)
print('gradient solver completed')
