# # Mitigating Conflicts in Multi-Task Reinforcement Learning via Progressively-Trained Dynamic Policy Network

In this supplementary material, we include our Appendix pdf. In different sub-folders, we include quadrupedal robot demo videos, quadrupedal robot codes and MiniHack codes.



## Quadrupedal Robot Demo

The quadrupedal robot demo videos are in folder `/quadrupedal_robot_demo/`. To keep the supplementary material under 100MB (required by the submission guideline), we accelerated all demo videos to reduce video size.

In video "1-full_design_demo", we demonstrate the performance of our method on the most difficult terrains that our policy network could complete properly.

In video "2-policy_for_parkour_only", we visualize the performance of policy network trained for parkour only on the hardest parkour terrains.

In video "3-policy_for_walking_only", we visualize the performance of policy network trained for walking tasks only on the hardest walking terrains.

In video "4-progressive_training+moe", we visualize the performance of policy network trained with progressive training but had an MoE architecture.

In video "5-progressive_training+mlp", we visualize the performance of policy network trained with progressive training but had an MLP architecture.

In video "6-naive_parallel_training+mlp", we visualize the performance of policy network trained with naive parallel training and had an MLP architecture.



## Quadrupedal Robot Codes

The quadrupedal robot codes are in folder `/quadrupedal_robot_codes/`

We present the DPNet code for the quadruped robot tasks.


##  MiniHack Codes.

The MiniHack codes are in folder `/MiniHack_codes/`

To train DPNet with progressive training on MiniHack:
```bash
pip install torch = 2.4.1 
pip install gym = 0.25.2 
pip install minihack = 0.1.6 
python main.py
```


