import argparse
from continual_rl.utils.configuration_loader import ConfigurationLoader
from continual_rl.available_policies import get_available_policies
from continual_rl.experiment_specs import get_available_experiments


class ArgumentMissingException(Exception):
    def __init__(self, error_str):
        super().__init__(error_str)


class ArgparseManager(object):

    def __init__(self):
        # You can initialize any needed defaults here
        self.output_dir = "/tmp"
        self.config_file = None
        self.resume_id = None

    def choose_parameters(self):
        """
        Instead of parsing from command line, this function allows you to set parameters directly in code.
        """
        # Example: directly setting the configuration for experiment and policy
        self.output_dir = "/tmp"  # set the output directory
        self.config_file = None  # set the path to the config file
        self.resume_id = 1  # set an experiment ID if you want to resume

        # Additional manual parameters for command-line mode
        raw_experiment = {
            "experiment": "minihack_nav_paired_2_cycles",  # specify the experiment name
            "policy": "ewc",  # specify the policy name
            # Add more parameters as needed
        }

        return raw_experiment

    def run(self):
        """
        This function handles the logic of running the experiment without command-line parsing.
        """
        # Load the available policies and experiments
        available_policies = get_available_policies()
        available_experiments = get_available_experiments()

        # Instantiate configuration loader
        configuration_loader = ConfigurationLoader(available_policies=available_policies,
                                                   available_experiments=available_experiments)

        if self.config_file is not None:
            print(f"Entering config mode using file {self.config_file} and output directory {self.output_dir}")

            if self.resume_id is not None:
                print(f"Resuming from experiment id {self.resume_id}")

            experiment, policy = configuration_loader.load_next_experiment_from_config(
                self.output_dir, self.config_file, resume_id=self.resume_id
            )
        else:
            raw_experiment = self.choose_parameters()

            if "experiment" not in raw_experiment:
                raise ArgumentMissingException("--experiment required in manual mode")

            if "policy" not in raw_experiment:
                raise ArgumentMissingException("--policy required in manual mode")

            # Load the experiment based on the parameters set in `choose_parameters`
            experiment, policy = configuration_loader.load_next_experiment_from_dicts(
                self.output_dir, [raw_experiment]
            )

        return experiment, policy





