import sys, os

os.environ["OMP_NUM_THREADS"] = "1"
# os.environ["TF_ENABLE_ONEDNN_OPTS"] = "0"

from torch import multiprocessing
from torch.utils.tensorboard.writer import SummaryWriter
from continual_rl.utils.argparse_manager import ArgparseManager

# import os
# os.environ["OMP_NUM_THREADS"] = "1"


if __name__ == "__main__":

    try:
        multiprocessing.set_start_method("spawn")
    except ValueError as e:
        assert "cannot find context" in str(e)
        multiprocessing.set_start_method("spawn")

    manager = ArgparseManager()
    experiment, policy = manager.run()
    print(experiment)
    print(policy)

    if experiment is None:
        raise RuntimeError("No experiment started. Most likely there is no new run to start.")

    summary_writer = SummaryWriter(log_dir=experiment.output_dir)
    experiment.try_run(policy, summary_writer=summary_writer)
