from continual_rl.experiments.experiment import Experiment
from continual_rl.experiments.tasks.make_minihack_task import get_single_minihack_task
from continual_rl.available_policies import LazyDict


def create_minihack_loader(
    task_prefix,
    env_name_pairs,
    num_timesteps=1e6,
    task_params=None,
    continual_testing_freq=1e5,
    cycle_count=1,
):
    task_params = task_params if task_params is not None else {}

    def loader():
        tasks = []
        for action_space_id, pairs in enumerate(env_name_pairs):
            train_task = get_single_minihack_task(f"{task_prefix}_{action_space_id}", action_space_id, pairs[0],
                                                  num_timesteps, **task_params)
            # print(train_task)
            eval_task = get_single_minihack_task(f"{task_prefix}_{action_space_id}_eval", action_space_id, pairs[1],
                                                 0, eval_mode=True, **task_params)

            tasks += [train_task, eval_task]

        return Experiment(
            tasks,
            continual_testing_freq=continual_testing_freq,
            cycle_count=cycle_count,
            num_timesteps=num_timesteps,
        )
    return loader


def get_available_experiments():

    experiments = LazyDict({
        # ===============================
        # ============ MiniHack =========
        # ===============================

        "minihack_nav_paired_2_cycles": create_minihack_loader(
            "minihack_nav_paired_2_cycles",
            [
                ("Room-Random-5x5-v0", "Room-Random-15x15-v0"),
                ("Corridor-R2-v0", "Corridor-R5-v0"),
                ("Room-Dark-5x5-v0", "Room-Dark-15x15-v0"),
                ("Corridor-R3-v0", "Corridor-R5-v0"),
                ("Room-Monster-5x5-v0", "Room-Monster-15x15-v0"),
                ("CorridorBattle-v0", "CorridorBattle-Dark-v0"),
                ("Room-Trap-5x5-v0", "Room-Trap-15x15-v0"),
                ("HideNSeek-v0", "HideNSeek-Big-v0"),
                ("Room-Ultimate-5x5-v0", "Room-Ultimate-15x15-v0"),
                ("HideNSeek-Lava-v0", "HideNSeek-Big-v0"),
            ],
            num_timesteps=1e6,
            continual_testing_freq=1e5,
            cycle_count=2,
        ),

    })

    return experiments
