#!/bin/bash





EXPERIMENT=$1
NAME=$2
SEED=$3
NODES=$4
EDGES=$5
ROOTCOUNT=$6
TIME=$7
ITER=$8

echo "Running seed ${SEED} of experiment ${EXPERIMENT} with iterator ${ITER} "






python -m data_generator.gen_dag \
-seed $SEED \
-shape "collision_plus_independent" \
-n "${ITER}" \
-path "synthetic_data_server/${EXPERIMENT}/${NAME}_input_dag.npy"


python -m data_generator.generate_data \
-seed $SEED \
-output-path "synthetic_data_server/${EXPERIMENT}/" \
-alarms "${NAME}_alarms.csv" \
-true-graph "${NAME}_true_graph.npy" \
-nodes $NODES \
-edges $EDGES \
-T "${TIME}" \
-delay-dist geom \
-delay-params-names p \
-delay-params-lower 0.01 \
-delay-params-upper 0.3 \
-skip-prob-range "0.1" "0.4" \
-root-count "${ROOTCOUNT}" \
--add-device \
-g-add-percentage 0.3 \
-m-add-percentage 0.0 \
-m-dest-percentage 0.0 \
-dag "synthetic_data_server/${EXPERIMENT}/${NAME}_input_dag.npy" \
-min-delay 1

