#!/bin/bash







DATA=$1
OUTPUT=$2
METHOD=$3
TRUEGRAPH=$4



if [[ $METHOD == "HExp" ]]; then
    method_params=" --decay 0.05"
fi

if [[ $METHOD == "NPHC" ]]; then
    PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION=python
    method_params=" --integration_support 20  --verbose"
fi

if [[ $METHOD == "HSG" ]]; then
    method_params=" --max_mean 1000 --n_gaussians 5  --verbose"
fi

if [[ $METHOD == "RPPN" ]]; then
    method_params=" --epoch 200  --init_scale 50 --cuda"
fi

if [[ $METHOD == "ERPP" ]]; then
    method_params=" --epoch 200 --cuda"
fi






DATA=$(realpath "$DATA")
OUTPUT=$(realpath "$OUTPUT")
TRUEGRAPH=$(realpath "$TRUEGRAPH")

echo "Running CAUSE on data ${DATA} with output ${OUTPUT}"

rm $OUTPUT
rm "${OUTPUT}.log"

start_time=$(date +%s)
python -m other_methods.CAUSE-master.tasks.run_cause -read-df True -alarms $DATA -true-graph $TRUEGRAPH -output $OUTPUT -float-output "${OUTPUT}.float.npy" $METHOD $method_params 2>&1 | tee "${OUTPUT}.log"
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
echo $elapsed_time > "${OUTPUT}_elapsed_time.txt"
