#!/bin/bash




DATA=$1
OUTPUT=$2
TRUEGRAPH=$3
OTHER=$4

echo "Running cascade -instant  on data ${DATA} with output ${OUTPUT}"




# rm "$OUTPUT"
# rm "${OUTPUT}.log"
# Save current time to a variable
start_time=$(date +%s)
python -m main -alarms $DATA -output $OUTPUT -true-graph $TRUEGRAPH -topology "empty" -search "topo" -candidate-delay "100" -precision 2 --instant --instant-idf $OTHER 2>&1 | tee "${OUTPUT}.log"
end_time=$(date +%s)
elapsed_time=$((end_time - start_time))
echo $elapsed_time > "${OUTPUT}_elapsed_time.txt"


# rm "${OUTPUT}_true_alignment.log"
# rm "${OUTPUT}_true_alignment_artifact.npy"
python -m main -alarms $DATA -output "${OUTPUT}_true_alignment_artifact.npy" -topology "empty" -causal $TRUEGRAPH -search "prior" -candidate-delay "1000" --instant-idf 2>&1 | tee "${OUTPUT}_true_alignment.log".
