#!/bin/bash




EXPERIMENT=$1
NAME=$2
SEED=$3
NODES=$4
EDGES=$5
ROOTCOUNT=$6
TIME=$7
SKIPL=$8
SKIPU=$9


echo "Running seed ${SEED} of experiment ${EXPERIMENT} with ${NODES} nodes and ${EDGES} edges"




python -m data_generator.generate_data \
-seed $SEED \
-output-path "synthetic_data_server/${EXPERIMENT}/" \
-alarms "${NAME}_alarms.csv" \
-true-graph "${NAME}_true_graph.npy" \
-nodes $NODES \
-edges $EDGES \
-T "${TIME}" \
-delay-dist geom \
-delay-params-names p \
-delay-params-lower 0.3 \
-delay-params-upper 1 \
-skip-prob-range "${SKIPL}" "${SKIPU}" \
-root-count "${ROOTCOUNT}" \
--add-device \
-g-add-percentage 0.0 \
-m-add-percentage 0.0 \
-m-dest-percentage 0.0 \
-min-delay 1

