import torch
import random
import numpy as np
import argparse

def print_trainable_parameters(model):
    trainable_params = 0
    all_params = 0
    
    for name, param in model.named_parameters():
        all_params += param.numel() 
        if param.requires_grad:
            trainable_params += param.numel()  
            # print(f"Trainable parameter: {name}, Shape: {param.shape}")
    
    print(f"\nTotal parameters: {all_params}")
    print(f"Trainable parameters: {trainable_params}")
    print(f"Non-trainable parameters: {all_params - trainable_params}")
    print(f"Percentage of trainable parameters: {100 * trainable_params / all_params:.2f}%")


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ("yes", "true", "t", "1"):
        return True
    elif v.lower() in ("no", "false", "f", "0"):
        return False
    else:
        raise argparse.ArgumentTypeError("Boolean value expected.")
    

def set_seed(seed: int = 42):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    print(f"Random seed is set to {seed}")
