# Create the output CSV and append header info


cleanup() {
    echo "Terminating all running jobs..."
    kill $(jobs -p) 2>/dev/null
    exit 1
}

# Trap SIGINT (Ctrl+C) and call cleanup function
trap 'cleanup' SIGINT

# Function to run the Python script
run_script() {
    python run_method.py --method "$2" --dataset "$1" --n_rules $n_rules --outpath "$3" &
}

# Maximum number of parallel jobs
max_parallel=10

# Function to wait if maximum parallel jobs are running
wait_for_jobs() {
    while [[ $(jobs -r | wc -l) -ge $max_parallel ]]; do
        sleep 1  # Wait for 1 second before checking again
    done
}

for method in our-rule-list rlnet mdl-rule-list greedy_rule_list 
do
    for setting in rule-size list-size sample-size 
    do
        if [ "$setting" = "rule-size" ]
        then
            datasets="2 4 6 8"
        elif [ "$setting" = "sample-size" ]
        then
            datasets="10 20 50 100 500 1000"
        elif [ "$setting" = "list-size" ]
        then
            datasets="2 4 6 8 12"
        fi
        # bayesian_rule_list optimal_rule_list
        echo "# Date: $(date)" > results/syn-$setting/$method.csv
        echo "# Commit-Hash: $(git rev-parse HEAD)" >> results/syn-$setting/$method.csv    
        echo "Dataset;n_rules;F1;F1_std;Acc;Acc_std;AUC;AUC_std;Runtime;Runtime_std" >> results/syn-$setting/$method.csv
        n_rules=15
        for dataset in $datasets
        do
            for i in {0..4}
            do
                run_script "syn_${setting}_${dataset}_${i}" "$method" "results/syn-$setting/"
                wait_for_jobs
            done
        done
    done
done