import glob
import json
from src.main.python.utils.filters import get_split

number_of_problems = 0
number_of_files = 0
split_count = {"train":0, "test":0, "val":0}

for filename in glob.glob('afp_extractions15/data/**.thy_output.json'):
    with open(filename) as f:
        data = json.load(f)
        number_of_problems += len(data["problems"])
        for p in data["problems"]:
            p["split"] = get_split(p["problem_name"])
            split_count[p["split"]] += 1
        number_of_files += 1
        print(number_of_problems, number_of_files, split_count)