# FGT-SNN
This is the PyTorch implementation of the submitted paper: Forward Gradient Training of Spiking Neural Networks. Please do not distribute.

## Dependencies and Installation
- Python 3 (Recommend to use [Anaconda](https://www.anaconda.com/download/#linux))
- [PyTorch, torchvision](https://pytorch.org/)
- NVIDIA GPU + [CUDA](https://developer.nvidia.com/cuda-downloads)
- Python packages: `pip install numpy opencv-python`

## Training
Run as following examples:

	python train_mnist_fcn.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_nmnist_fcn.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_cifar.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_cifar10dvs.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	python train_dvsgesture.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	# add the argument for stochastic neuron model
	-stochastic
	
	# add the argument for FGT(S)
	-sample_layer
	
	# add the argument for FGT(Q1)
	-forward_quantize -q_scale 1. -q_timesteps 1
	
	# add the argument for combination with local loss
	-local_loss
	
	# add the argument for vanilla forward gradient without momentum feedback
	-not_momentum_feedback -sample_num 1
	
	# add the argument for BP instead of FGT
	-bp
	
	# add the argument for DFA instead of FGT
	-DFA
	
	# add the argument for DKP instead of FGT
	-DKP
	
	# add the argument for only local loss rather than FGT
	-local_loss -only_local_loss
	
	# analyze gradient angle and variance during training
	python train_cifar10dvs_analyzegrad.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -gpu-id 0
	
	# intermediate global learning for deeper networks
	python train_cifar_igl.py -data_dir path_to_data_dir -out_dir log_checkpoint_name -model fgtonline_spiking_dcnn_ws -gpu-id 0

The default hyperparameters are the same as the paper and the default random seed is set as 2022.
