method DeepCopySeq(s: seq<int>) returns (copy: seq<int>)
    ensures |copy| == |s|
    ensures forall i :: 0 <= i < |s| ==> copy[i] == s[i]
{
    var newSeq: seq<int> := [];
    for i := 0 to |s|
        invariant 0 <= i <= |s|
        invariant |newSeq| == i
        invariant forall k :: 0 <= k < i ==> newSeq[k] == s[k]
    {
        newSeq := newSeq + [s[i]];
    }
    return newSeq;
}