# coding=utf-8
# Copyright 2025 The Dp Mm Domain Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from absl.testing import absltest
from dp_mm_domain import hitting_set_mechanisms


class HittingSetMechanismsTest(absltest.TestCase):

  def test_greedy_hitting_set(self):
    input_data = [[1, 2, 3], [1, 2, 4], [1, 5], [6, 7], [6, 9]]
    output_set = hitting_set_mechanisms.greedy_hitting_set(input_data, 2)
    self.assertSetEqual(output_set, {1, 6})

if __name__ == "__main__":
  absltest.main()
