import numpy as np
from tensorflow.keras.callbacks import Callback


class StopAtCertainError(Callback):
    def __init__(self, error=1e-6):
        super().__init__()
        self.error = error

    def on_epoch_end(self, epoch, logs=None):
        if logs.get("val_loss") <= self.error:
            self.model.stop_training = True
