from scipy.stats import norm
from scipy.integrate import quad
import numpy as np

# Parameters for the normal distribution
r_a = 4  # mean
sigma = 2  # standard deviation

# Probability density function of the normal distribution
pdf = lambda r_b: norm.pdf(r_b, r_a, sigma)

# Probability density function of the exponential distribution



# The integral for r_b <= r_a
integral_1 = quad(lambda r_b: r_b * np.exp(r_b - r_a) * pdf(r_b), -np.inf, r_a)[0]

# The integral for r_b > r_a
integral_2 = quad(lambda r_b: r_b * pdf(r_b), r_a, np.inf)[0]

# The integral for selecting r_a
integral_3 = r_a * quad(lambda r_b: (1 - np.exp(r_b - r_a)) * pdf(r_b), -np.inf, r_a)[0]

# The integral for selecting r_a when r_b > r_a (which is 0 since the probability is 0)
integral_4 = 0

# Expected value
expected_value = integral_1 + integral_2 + integral_3 + integral_4
print(f'Expected value: {expected_value}, integral_1: {integral_1}, integral_2: {integral_2}, integral_3: {integral_3}, integral_4: {integral_4}')
