# Anonymouse Submission Statement
We provide main components of our code for review purpose in Neurips 2024.
We plan to clean up and release the code upon acceptance.
This code is likely not runnable without clean up because we removed files containing author informations or unimportant files.
Instruction for using the code is provided below to guide the readers read through.


# Instructions

All experiments can be launched via `python -m main [options]` where you can fine more details later in this article.

The code base will automatically use cuda or your Macbook M1 GPU when available.

For slurm clusters e.g. author_slurm_1, you can run `python -m main cluster=author_slurm_1 [options]` on login node. 
It will automatically generate slurm scripts and run them for you on a compute node. Even if compute nodes are offline, 
the script will still automatically sync wandb logging to cloud with <1min latency. It's also easy to add your own slurm
by following the `Add slurm clusters` section.
## Setup

Run `conda create python=3.10 -n [your_env_name]` to create environment.
Run `conda activate [your_env_name]` to activate this environment.
Run `pip install -r requirements.txt` to install all dependencies.

[Sign up](https://wandb.ai/site) a wandb account for cloud logging and checkpointing. In command line, run `wandb login` to login.

Then modify the wandb entity (account) in `configurations/config.yaml`.

If using VScode, please modify `.vscode/settings.json` so python interpreter is set correctly.

## Run built-in example
Train video prediction:
`python main.py +name=debug_video experiment=exp_video algorithm=df_video dataset=video_dmlab `

Test video prediction:
`python main.py +name=debug_video experiment=exp_video algorithm=df_video dataset=video_dmlab  experiment.tasks=[test] load=replace_me`


## Pass in arguments

We use [hydra](https://hydra.cc) instead of `argparse` to configure arguments at every code level. You can both write a static config in `configuration` folder or, at runtime,
[override part of yur static config](https://hydra.cc/docs/tutorials/basic/your_first_app/simple_cli/) with command line arguments. 

For example, arguments `algorithm=example_classifier algorithm.lr=1e-3` will override the `lr` variable in `configurations/algorithm/example_classifier.yaml`. The argument `` will override the `mode` under `wandb` namesspace in the file `configurations/config.yaml`.

All static config and runtime override will be logged to cloud automatically.


## Resume a checkpoint & logging
For machine learning experiments, all checkpoints and logs are logged to cloud automatically so you can resume them on another server. Simply append `resume=[wandb_run_id]` to your command line arguments to resume it. The run_id can be founded in a url of a wandb run in wandb dashboard.

On the other hand, sometimes you may want to start a new run with different run id but still load a prior ckpt. This can be done by setting the `load=[wandb_run_id / ckpt path]` flag.

## Modify for your own project

First, create a new repository with this template. Make sure the new repository has the name you want to use for wandb
logging.

Add your method and baselines in `algorithms` following the `algorithms/README.md` as well as the example code in
`algorithms/examples/classifier/classifier.py`. For pytorch experiments, write your algorithm as a [pytorch lightning](https://github.com/Lightning-AI/lightning)
`pl.LightningModule` which has extensive
[documentation](https://lightning.ai/docs/pytorch/stable/). For a quick start, read "Define a LightningModule" in this [link](https://lightning.ai/docs/pytorch/stable/starter/introduction.html). Finally, add a yaml config file to `configurations/algorithm` imitating that of `configurations/algorithm/example_classifier.yaml`, for each algorithm you added.

(If doing machine learning) Add your dataset in `datasets` following the `datasets/README.md` as well as the example code in
`datasets/classification.py`. Finally, add a yaml config file to `configurations/dataset` imitating that of
`configurations/dataset/example_cifar10.yaml`, for each dataset you added.

Add your experiment in `experiments` following the `experiments/README.md` or following the example code in
`experiments/exp_classification.py`. Then register your experiment in `experiments/__init__.py`.
Finally, add a yaml config file to `configurations/experiment` imitating that of
`configurations/experiment/example_classification.yaml`, for each experiment you added. 

Modify `configurations/config.yaml` to set `algorithm` to the yaml file you want to use in `configurations/algorithm`;
set `experiment` to the yaml file you want to use in `configurations/experiment`; set `dataset` to the yaml file you
want to use in `configurations/dataset`, or to `null` if no dataset is needed; Notice the fields should not contain the
`.yaml` suffix.

You are all set!

`cd` into your project root. Now you can launch your new experiment with `python main.py +name=example_name`. For a debug run, simply set `wandb.mode=offline` to diable cloud logging. You can run baselines or
different datasets by add arguments like `algorithm=[xxx]` or `dataset=[xxx]`. You can also override any `yaml` configurations by following the next section.

One special note, if your want to define a new task for your experiment, (e.g. other than `training` and `test`) you can define it as a method in your experiment class (e.g. the `main` task in `experiments/example_helloworld.py`) and use `experiment.tasks=[task_name]` to run it. Let's say you have a `generate_dataset` task before the task `training` and you implemented it in experiment class, you can then run `python -m main +name xxxx experiment.tasks=[generate_dataset,training]` to execute it before training.

## Debug
We provide a useful debug flag which you can enable by `python main.py debug=True`. This will enable numerical error tracking as well as setting `cfg.debug` to `True` for your experiments, algorithms and datasets class. However, this debug flag will make ML code very slow as it automatically tracks all parameter / gradients!

## Hyperparameter Sweep

Launch hyperparameter sweep via: `wandb sweep configurations/sweep/example_sweep.yaml`
Then, launch sweep agents on different servers by running the command printed by the controller (e.g., `wandb agent <agent_id>`).

# Project Specific Instructions


Run `conda create python=3.10 -n diffusion_forcing` to create environment.
Run `conda activate diffusion_forcing` to activate this environment.
Run `pip install -r requirements.txt` to install all dependencies.

