from datasets import MinerlVideoDataset, DmlabVideoDataset
from algorithms.image_diffusion.diffusion import ImageDiffusion
from .exp_base import BaseLightningExperiment


class ImageDiffusionExperiment(BaseLightningExperiment):
    """
    A image prediction experiment
    """

    compatible_algorithms = dict(
        image_diffusion=ImageDiffusion,
    )

    compatible_datasets = dict(
        # video datasets
        video_dmlab=DmlabVideoDataset,
    )
