# Reproduction Guidelines

In this instruction, we provide a step-by-step guidelines to reproduce the experiments and the visualization for the gradient-based mesh optimization experiment. 

## Install dependencies
We have use `pip freeze > requirements.txt` to generate the required dependencies. Follow these given steps to set up the environment:
1. Run `cd mesh-opt`.
2. Install dependencies: `pip -r install requirements.txt`
3. Install the `mesh-opt` package: `pip install -e .`. 
We require Python version higher than 3.12. You may edit it in `setup.py`. There is no hard constraint on the Python version or other package version. 

## Run experiments
We have included all hyper-parameters in `mesh-opt/baseline_configs`. Simply run
```bash
# Baseline 0: Change `CONFIG_PATH` to "../baseline_configs/center_uniform.yaml"
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-center-uniform --step-size 500.0 

# Baseline 1: Change `CONFIG_PATH` to "../baseline_configs/rejection_method.yaml"
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-rejection-method --step-size 500.0
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-rejection-method --step-size 400.0
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-rejection-method --step-size 300.0

# Baseline 2: Change `CONFIG_PATH` to "../baseline_configs/mesh_aware_enhanced.yaml"
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-mesh-aware --step-size 500.0 
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-mesh-aware --step-size 400.0 
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-mesh-aware --step-size 300.0 

# Our Method: Change `CONFIG_PATH` to "../baseline_configs/convex_combination.yaml" 
python examples/helmholtz_equation.py --wavenumber 10 --iterations 20000 --output ./results/helmholtz-baselines-convex-combination --step-size 500.0 
```
Before running experiments, ensure to modify these paths to an absolute path and add wandb information to configuration files. 

We note that we are using different names from our paper. Here is the correspondance:
* `center_uniform`: Unconstrained 
* `rejection_method`: Reversion
* `mesh_aware_enhanced`: Soft projection
* `convex_combination`：Structure preserving


## Visualization
We also include our visualization script with our submission. Check with the provided jupyter notebook to visualize the results. 
