# Semi-supervised Keypoint Localization

## Overview
This is an implementation of a semi-supervised method for keypoint localization that learns keypoint heatmaps and semantic keypoint representations simultaneously. The model learns from a subset of labeled images and a set of unlabeled images. The method is the most benefitial in low data regimes.
## Data
Images for all datasets and annotations for MPII are not provided due to supplementary material size limitations. Lists with labeled/unlabeled splits are saved in annotations.

## Installation

* Python >= 3.7
* PyTorch >= 1.5
* Kornia = 0.3 (a differentiable computer vision library for PyTorch)


## Usage
### Training
Run the training script:
```
python train_semi.py --cfg experiments/<dataset_name>/<experiment_config_yaml> <additional_optional_params>
```
Important parameters are:
* `DATASET.LABELS_SPLIT_FILE` - specifies labeled/unlabeled images
* `VERSION` - suffix for output folder to save different runs of the same experiment in different folders
For example, a filename with the labeled split and a version are added as parameters to run an experiment on a specific dataset split:
```
python train_semi.py --cfg experiments/lsp/1_supervised.yaml DATASET.LABELS_SPLIT_FILE 'labelled_5_run_0.txt' VERSION 'v5_0'
```
### Testing
The test script evaluates on the test set with the best model saved during training:
```
python test_semi.py --cfg experiments/<dataset_name>/<experiment_config_yaml> VERSION <version>
```

