def load_public_graph(graph_save_loc):
    with open(graph_save_loc, "r") as f:
        edges = []
        for line in f:
            if line.startswith("p edge"):
                _, _, num_nodes, num_edges = line.strip().split(" ")
                num_nodes = int(num_nodes)
                num_edges = int(num_edges)
            elif line.startswith("e "):
                edge = line.strip().split(" ")
                edges.append((int(edge[1]), int(edge[2])))

        # 初始化邻接矩阵
        adj_matrix = [[0 for _ in range(num_nodes)] for _ in range(num_nodes)]

        # 根据边信息构建邻接矩阵
        for edge in edges:
            adj_matrix[edge[0] - 1][edge[1] - 1] = 1
            adj_matrix[edge[1] - 1][edge[0] - 1] = 1
    return adj_matrix


path = "/root/autodl-tmp/N2GraphColor/_graphs/public_data/david.col"

adj_matrix= load_public_graph(path)
n = len(adj_matrix)
print("n",n)
total_possible_connections = n * (n - 1)
actual_connections = sum([sum(row) for row in adj_matrix]) // 2  # 无向图，每个连接被计算两次
connection_rate = actual_connections / total_possible_connections

print(f"连接率: {connection_rate}")

