import numpy as np

from Normalization.Normalizers import MinMaxNormalizer, ABNormalizer


def get_normalizers(Data_List, era5_network):
    station_tp_mins = []
    station_tp_maxs = []

    for Data in Data_List:
        station_tp_mins.append(Data.station_tp_min)
        station_tp_maxs.append(Data.station_tp_max)


    station_tp_min = np.min(np.array(station_tp_mins))
    station_tp_max = np.max(np.array(station_tp_maxs))
    station_scale = np.max(np.array([np.abs(station_tp_min),station_tp_max]))

    station_tp_normalizer = ABNormalizer(-station_scale, station_scale, -1.0, 1.0)
    station_norm_dict = {'tp': station_tp_normalizer}

    if era5_network is not None:
        era5_tp_mins = []

        era5_tp_maxs = []

        for Data in Data_List:
            era5_tp_mins.append(Data.era5_tp_min)
            era5_tp_maxs.append(Data.era5_tp_max)

        era5_tp_min = np.min(np.array(era5_tp_mins))
        era5_tp_max = np.max(np.array(era5_tp_maxs))
        era5_scale = np.max(np.array([np.abs(era5_tp_min), era5_tp_max]))

        era5_tp_normalizer = MinMaxNormalizer(-era5_scale, era5_scale)

        era5_norm_dict = {'tp': era5_tp_normalizer}
    else:
        era5_norm_dict = None

    return station_norm_dict, era5_norm_dict
